/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.model;

import com.microsoft.azure.toolkit.lib.auth.exception.InvalidConfigurationException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum AuthType {
    AUTO,
    SERVICE_PRINCIPAL,
    AZURE_AUTH_MAVEN_PLUGIN,
    MANAGED_IDENTITY,
    AZURE_CLI,
    VSCODE,
    INTELLIJ_IDEA,
    VISUAL_STUDIO,
    DEVICE_CODE,
    OAUTH2;


    public static AuthType parseAuthType(String type) throws InvalidConfigurationException {
        if (StringUtils.isBlank((CharSequence)type)) {
            return AUTO;
        }
        switch (StringUtils.replace((String)type.toLowerCase().trim(), (String)"-", (String)"_")) {
            case "auto": {
                return AUTO;
            }
            case "service_principal": {
                return SERVICE_PRINCIPAL;
            }
            case "managed_identity": {
                return MANAGED_IDENTITY;
            }
            case "azure_cli": {
                return AZURE_CLI;
            }
            case "vscode": {
                return VSCODE;
            }
            case "intellij": {
                return INTELLIJ_IDEA;
            }
            case "azure_auth_maven_plugin": {
                return AZURE_AUTH_MAVEN_PLUGIN;
            }
            case "device_code": {
                return DEVICE_CODE;
            }
            case "oauth2": {
                return OAUTH2;
            }
            case "visual_studio": {
                return VISUAL_STUDIO;
            }
        }
        throw new InvalidConfigurationException(String.format("Invalid auth type '%s', supported values are: %s.", type, Arrays.stream(AuthType.values()).map(Object::toString).map(StringUtils::lowerCase).collect(Collectors.joining(", "))));
    }
}

