/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.oauth;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.InteractiveBrowserCredentialBuilder;
import com.azure.identity.TokenCachePersistenceOptions;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.RefreshTokenTokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import java.awt.Desktop;
import me.alexpanov.net.FreePortFinder;
import reactor.core.publisher.Mono;

public class OAuthAccount
extends Account {
    @Override
    public AuthType getAuthType() {
        return AuthType.OAUTH2;
    }

    @Override
    public String getClientId() {
        return "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
    }

    @Override
    public Mono<Boolean> checkAvailable() {
        return this.preLoginCheck();
    }

    @Override
    protected Mono<Boolean> preLoginCheck() {
        return Mono.fromCallable(() -> {
            if (!OAuthAccount.isBrowserAvailable()) {
                throw new AzureToolkitAuthenticationException("browser is not available for oauth login.");
            }
            return true;
        });
    }

    @Override
    protected Mono<TokenCredentialManager> createTokenCredentialManager() {
        AzureEnvironment env = ((AzureCloud)Azure.az(AzureCloud.class)).getOrDefault();
        return RefreshTokenTokenCredentialManager.createTokenCredentialManager(env, this.getClientId(), this.createCredential(env));
    }

    protected TokenCredential createCredential(AzureEnvironment env) {
        AzureEnvironmentUtils.setupAzureEnvironment(env);
        InteractiveBrowserCredentialBuilder builder = new InteractiveBrowserCredentialBuilder();
        if (this.isEnablePersistence()) {
            builder.tokenCachePersistenceOptions(new TokenCachePersistenceOptions().setName("azure-toolkit.cache"));
        }
        return builder.redirectUrl("http://localhost:" + FreePortFinder.findFreeLocalPort()).build();
    }

    private static boolean isBrowserAvailable() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }
}

