/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.google.common.base.MoreObjects;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.auth.core.ChainedCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.ICredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.azurecli.AzureCliCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.devicecode.DeviceCodeCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.managedidentity.ManagedIdentityCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.maven.MavenLoginCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.oauth.OAuthCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.serviceprincipal.ServicePrincipalCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.exception.LoginFailureException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCredentialWrapper;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import rx.Single;

public class AzureAuthManager {
    protected Single<AzureCredentialWrapper> login(AuthConfiguration configuration) {
        AuthConfiguration auth = (AuthConfiguration)MoreObjects.firstNonNull((Object)configuration, (Object)new AuthConfiguration());
        AzureEnvironmentUtils.setupAzureEnvironment(auth.getEnvironment());
        ChainedCredentialRetriever chainedCredentialRetriever = new ChainedCredentialRetriever();
        AuthType authType = (AuthType)((Object)MoreObjects.firstNonNull((Object)((Object)auth.getType()), (Object)((Object)AuthType.AUTO)));
        Map<AuthType, ICredentialRetriever> allRetrievers = AzureAuthManager.buildCredentialRetrievers(configuration);
        if (authType.equals((Object)AuthType.AUTO)) {
            for (ICredentialRetriever retriever : allRetrievers.values()) {
                chainedCredentialRetriever.addRetriever(retriever);
            }
        } else {
            if (!allRetrievers.containsKey((Object)authType)) {
                return Single.error((Throwable)new UnsupportedOperationException(String.format("authType '%s' not supported.", new Object[]{authType})));
            }
            chainedCredentialRetriever.addRetriever(allRetrievers.get((Object)authType));
        }
        return chainedCredentialRetriever.retrieve().onErrorResumeNext(e -> Single.error((Throwable)new LoginFailureException(String.format("Cannot get credentials from authType '%s' due to error: %s", new Object[]{authType, e.getMessage()}))));
    }

    private static Map<AuthType, ICredentialRetriever> buildCredentialRetrievers(AuthConfiguration auth) {
        AzureEnvironment env = auth.getEnvironment();
        LinkedHashMap<AuthType, ICredentialRetriever> map = new LinkedHashMap<AuthType, ICredentialRetriever>();
        map.put(AuthType.SERVICE_PRINCIPAL, new ServicePrincipalCredentialRetriever(auth));
        map.put(AuthType.MANAGED_IDENTITY, new ManagedIdentityCredentialRetriever(auth));
        map.put(AuthType.AZURE_CLI, new AzureCliCredentialRetriever(env));
        map.put(AuthType.OAUTH2, new OAuthCredentialRetriever(env));
        map.put(AuthType.DEVICE_CODE, new DeviceCodeCredentialRetriever(env));
        map.put(AuthType.AZURE_AUTH_MAVEN_PLUGIN, new MavenLoginCredentialRetriever(env));
        return map;
    }
}

