/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AzureIdentityCredentialTokenCredentials
extends AzureTokenCredentials {
    private final TokenCredential tokenCredential;
    private final Map<String, AccessToken> accessTokenCache = new ConcurrentHashMap<String, AccessToken>();
    private final String[] scopes;

    public AzureIdentityCredentialTokenCredentials(AzureEnvironment environment, String tenantId, TokenCredential tokenCredential) {
        this(environment, tenantId, tokenCredential, new String[]{environment.managementEndpoint() + "/.default"});
    }

    public AzureIdentityCredentialTokenCredentials(AzureEnvironment environment, String tenantId, TokenCredential tokenCredential, String[] scopes) {
        super(environment, tenantId);
        this.tokenCredential = tokenCredential;
        this.scopes = scopes;
    }

    public String getToken(String endpoint) {
        if (!this.accessTokenCache.containsKey(endpoint) || this.accessTokenCache.get(endpoint).isExpired()) {
            this.accessTokenCache.put(endpoint, (AccessToken)this.tokenCredential.getToken(new TokenRequestContext().addScopes(this.scopes)).block());
        }
        return this.accessTokenCache.get(endpoint).getToken();
    }
}

