/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.devicecode;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DeviceCodeCredential;
import com.azure.identity.DeviceCodeCredentialBuilder;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.auth.core.AbstractCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.core.legacy.LegacyAsyncCredentialProxy;
import com.microsoft.azure.toolkit.lib.auth.core.legacy.LegacyRefreshTokenCredentialFactory;
import com.microsoft.azure.toolkit.lib.auth.model.AuthMethod;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCredentialWrapper;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import org.apache.commons.lang3.StringUtils;

public class DeviceCodeCredentialRetriever
extends AbstractCredentialRetriever {
    private static final String AZURE_TOOLKIT_CLIENT_ID = "777acee8-5286-4d6e-8b05-f7c851d8ed0a";

    public DeviceCodeCredentialRetriever(AzureEnvironment env) {
        super(env);
    }

    @Override
    public AzureCredentialWrapper retrieveInternal() {
        DeviceCodeCredential deviceCodeCredential = ((DeviceCodeCredentialBuilder)new DeviceCodeCredentialBuilder().clientId(AZURE_TOOLKIT_CLIENT_ID)).challengeConsumer(challenge -> System.out.println(StringUtils.replace((String)challenge.getMessage(), (String)challenge.getUserCode(), (String)TextUtils.cyan((String)challenge.getUserCode())))).build();
        return new AzureCredentialWrapper(AuthMethod.DEVICE_CODE, new LegacyAsyncCredentialProxy(LegacyRefreshTokenCredentialFactory.createRefreshTokenCredential(this.getAzureEnvironment(), (TokenCredential)deviceCodeCredential)), this.getAzureEnvironment());
    }
}

