/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.legacy;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.ScopeUtil;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.resources.models.Tenant;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.auth.exception.LoginFailureException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.net.MalformedURLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import reactor.core.publisher.Mono;

public class LegacyRefreshTokenCredentialFactory {
    public static Mono<TokenCredential> createRefreshTokenCredential(AzureEnvironment environment, TokenCredential tokenCredential) {
        return tokenCredential.getToken(new TokenRequestContext().addScopes(ScopeUtil.resourceToScopes((String)environment.managementEndpoint()))).map(accessToken -> {
            String refreshTokenFromResult;
            IAuthenticationResult result = ((MsalToken)accessToken).getAuthenticationResult();
            try {
                refreshTokenFromResult = (String)FieldUtils.readField((Object)result, (String)"refreshToken", (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new AzureToolkitRuntimeException("Cannot read refreshToken from IAuthenticationResult.");
            }
            if (StringUtils.isBlank((CharSequence)refreshTokenFromResult)) {
                throw new AzureToolkitRuntimeException("Fail to get refresh token.");
            }
            List<String> tenantIds = LegacyRefreshTokenCredentialFactory.listTenantIds(environment, tokenCredential);
            if (CollectionUtils.isEmpty(tenantIds)) {
                throw new AzureToolkitRuntimeException("There are no tenants in your account.");
            }
            return LegacyRefreshTokenCredentialFactory.fromRefreshToken(environment, "04b07795-8ddb-461a-bbee-02f9e1bf7b46", tenantIds.get(0), refreshTokenFromResult);
        });
    }

    public static TokenCredential fromRefreshToken(AzureEnvironment env, String clientId, String tenantId, String refreshToken) {
        return LegacyRefreshTokenCredentialFactory.buildRefreshTokenCredential(env, clientId, tenantId, refreshToken);
    }

    private static TokenCredential buildRefreshTokenCredential(AzureEnvironment env, String clientId, String tenantId, String refreshToken) {
        return request -> Mono.fromCallable(() -> {
            AuthenticationResult result = LegacyRefreshTokenCredentialFactory.authorize(env, clientId, (String)StringUtils.firstNonBlank((CharSequence[])new String[]{tenantId, "common"}), refreshToken, StringUtils.isBlank((CharSequence)tenantId) ? null : ScopeUtil.scopesToResource((List)request.getScopes()));
            return LegacyRefreshTokenCredentialFactory.fromAuthenticationResult(result);
        });
    }

    private static AccessToken fromAuthenticationResult(AuthenticationResult authenticationResult) {
        if (authenticationResult == null) {
            return null;
        }
        OffsetDateTime expiresOnDate = authenticationResult.getExpiresOnDate() == null ? OffsetDateTime.MAX : OffsetDateTime.ofInstant(authenticationResult.getExpiresOnDate().toInstant(), ZoneOffset.UTC);
        return new AccessToken(authenticationResult.getAccessToken(), expiresOnDate);
    }

    private static AuthenticationResult authorize(AzureEnvironment env, String clientId, String tenantId, String refreshToken, String resource) throws LoginFailureException, MalformedURLException {
        AuthenticationResult result;
        String authorityUrl = env.activeDirectoryEndpoint().replaceAll("/+$", "") + "/" + tenantId;
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            AuthenticationContext context = new AuthenticationContext(authorityUrl, true, service);
            Future future = context.acquireTokenByRefreshToken(refreshToken, clientId, resource, null);
            result = (AuthenticationResult)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new LoginFailureException(e.getMessage(), e);
        }
        finally {
            service.shutdown();
        }
        if (result == null) {
            throw new LoginFailureException("authentication result was null");
        }
        return result;
    }

    private static List<String> listTenantIds(AzureEnvironment environment, TokenCredential credential) {
        com.azure.core.management.AzureEnvironment azureEnvironment = com.azure.core.management.AzureEnvironment.knownEnvironments().stream().filter(e -> StringUtils.equals((CharSequence)e.getActiveDirectoryEndpoint(), (CharSequence)environment.activeDirectoryEndpoint())).findFirst().orElse(null);
        return AzureResourceManager.authenticate((TokenCredential)credential, (AzureProfile)new AzureProfile(azureEnvironment)).tenants().list().stream().map(Tenant::tenantId).collect(Collectors.toList());
    }
}

