/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.managedidentity;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.core.AbstractCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.exception.LoginFailureException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthMethod;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCredentialWrapper;
import javax.annotation.Nonnull;

public class ManagedIdentityCredentialRetriever
extends AbstractCredentialRetriever {
    private String clientId;

    public ManagedIdentityCredentialRetriever(@Nonnull AuthConfiguration configuration) {
        super(configuration.getEnvironment());
        this.clientId = configuration.getClient();
    }

    @Override
    public AzureCredentialWrapper retrieveInternal() throws LoginFailureException {
        ManagedIdentityCredential managedIdentityCredential = new ManagedIdentityCredentialBuilder().clientId(this.clientId).build();
        this.validateTokenCredential((TokenCredential)managedIdentityCredential);
        return new AzureCredentialWrapper(AuthMethod.MANAGED_IDENTITY, (TokenCredential)managedIdentityCredential, this.getAzureEnvironment());
    }
}

