/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.serviceprincipal;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.core.AbstractCredentialRetriever;
import com.microsoft.azure.toolkit.lib.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.auth.exception.LoginFailureException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthMethod;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCredentialWrapper;
import com.microsoft.azure.toolkit.lib.auth.util.ValidationUtil;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ServicePrincipalCredentialRetriever
extends AbstractCredentialRetriever {
    private AuthConfiguration auth;

    public ServicePrincipalCredentialRetriever(@Nonnull AuthConfiguration auth) {
        super(auth.getEnvironment());
        this.auth = auth;
    }

    @Override
    public AzureCredentialWrapper retrieveInternal() throws LoginFailureException {
        try {
            ValidationUtil.validateAuthConfiguration(this.auth);
        }
        catch (InvalidConfigurationException e) {
            throw new LoginFailureException(e.getMessage());
        }
        return this.mavenSettingLogin(AuthMethod.SERVICE_PRINCIPAL, this.auth);
    }

    private AzureCredentialWrapper mavenSettingLogin(AuthMethod method, AuthConfiguration configuration) throws LoginFailureException {
        ClientSecretCredential clientSecretCredential = StringUtils.isNotBlank((CharSequence)configuration.getCertificate()) ? ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(configuration.getClient())).pfxCertificate(configuration.getCertificate(), configuration.getCertificatePassword()).tenantId(configuration.getTenant())).build() : ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(configuration.getClient())).clientSecret(configuration.getKey()).tenantId(configuration.getTenant())).build();
        this.validateTokenCredential((TokenCredential)clientSecretCredential);
        return new AzureCredentialWrapper(method, (TokenCredential)clientSecretCredential, this.getAzureEnvironment()).withTenantId(configuration.getTenant());
    }

    public AuthConfiguration getAuth() {
        return this.auth;
    }
}

