/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.util;

import com.azure.core.util.Configuration;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AzureEnvironmentUtils {
    private static final Map<AzureEnvironment, String[]> AZURE_CLOUD_ALIAS_MAP = new HashMap<AzureEnvironment, String[]>();

    public static String azureEnvironmentToString(AzureEnvironment azureEnvironment) {
        if (AZURE_CLOUD_ALIAS_MAP.containsKey(azureEnvironment)) {
            return AZURE_CLOUD_ALIAS_MAP.get(azureEnvironment)[1];
        }
        throw new IllegalArgumentException("Unknown azure environment.");
    }

    public static String getCloudNameForAzureCli(AzureEnvironment azureEnvironment) {
        if (AZURE_CLOUD_ALIAS_MAP.containsKey(azureEnvironment)) {
            return AZURE_CLOUD_ALIAS_MAP.get(azureEnvironment)[0];
        }
        throw new IllegalArgumentException("Unknown azure environment.");
    }

    public static void setupAzureEnvironment(AzureEnvironment env) {
        AzureEnvironmentUtils.setPropertyIfNotExist("org.slf4j.simpleLogger.log.com.azure.identity", "off");
        AzureEnvironmentUtils.setPropertyIfNotExist("org.slf4j.simpleLogger.log.com.microsoft.aad.msal4jextensions", "off");
        if (env != null && env != AzureEnvironment.AZURE) {
            Configuration.getGlobalConfiguration().put("AZURE_AUTHORITY_HOST", env.activeDirectoryEndpoint());
        }
    }

    public static AzureEnvironment stringToAzureEnvironment(String environment) {
        String targetEnvironment = StringUtils.replaceChars((String)environment, (char)'-', (char)'_');
        return AZURE_CLOUD_ALIAS_MAP.entrySet().stream().filter(entry -> Utils.containsIgnoreCase(Arrays.asList((Object[])entry.getValue()), (String)targetEnvironment)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private static void putAliasMap(AzureEnvironment env, String ... aliases) {
        AZURE_CLOUD_ALIAS_MAP.put(env, aliases);
    }

    private static void setPropertyIfNotExist(String key, String value) {
        if (StringUtils.isBlank((CharSequence)System.getProperty(key))) {
            System.setProperty(key, value);
        }
    }

    static {
        AzureEnvironmentUtils.putAliasMap(AzureEnvironment.AZURE, "AzureCloud", "azure", "azure_cloud");
        AzureEnvironmentUtils.putAliasMap(AzureEnvironment.AZURE_CHINA, "AzureChinaCloud", "azure_china", "AzureChina", "azure_china_cloud");
        AzureEnvironmentUtils.putAliasMap(AzureEnvironment.AZURE_GERMANY, "AzureGermanCloud", "azure_germany", "azure_german", "azure_germany_cloud", "azure_german_cloud", "AzureGerman", "AzureGermany");
        AzureEnvironmentUtils.putAliasMap(AzureEnvironment.AZURE_US_GOVERNMENT, "AzureUSGovernment", "azure_us_government");
    }
}

