/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.oauth;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.InteractiveBrowserCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import java.awt.Desktop;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.alexpanov.net.FreePortFinder;

public class OAuthAccount
extends Account {
    private final AuthType type = AuthType.OAUTH2;

    public OAuthAccount() {
        this(new AuthConfiguration(AuthType.OAUTH2));
    }

    public OAuthAccount(@Nonnull AuthConfiguration config) {
        super(config);
    }

    @Override
    public boolean checkAvailable() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        String tenantId = Optional.of(this.getConfig()).map(AuthConfiguration::getTenant).orElse(null);
        return ((InteractiveBrowserCredentialBuilder)((InteractiveBrowserCredentialBuilder)((InteractiveBrowserCredentialBuilder)new InteractiveBrowserCredentialBuilder().clientId(this.getClientId())).tenantId(tenantId)).additionallyAllowedTenants(new String[]{"*"}).tokenCachePersistenceOptions(this.getPersistenceOptions()).redirectUrl("http://localhost:" + FreePortFinder.findFreeLocalPort()).executorService(this.getConfig().getExecutorService())).build();
    }

    @Override
    public AuthType getType() {
        return this.type;
    }
}

