/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.devicecode;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DeviceCodeCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public class DeviceCodeAccount
extends Account {
    private final AuthType type = AuthType.DEVICE_CODE;

    public DeviceCodeAccount(@Nonnull AuthConfiguration config) {
        super(config);
        if (Objects.isNull(config.getDeviceCodeConsumer())) {
            throw new AzureToolkitRuntimeException("device code consumer is not configured.");
        }
    }

    @Override
    public boolean checkAvailable() {
        return true;
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        AuthConfiguration config = this.getConfig();
        if (Optional.ofNullable(config.getExecutorService()).filter(ExecutorService::isShutdown).isPresent()) {
            throw new AzureToolkitAuthenticationException("device login twice is forbidden.");
        }
        return ((DeviceCodeCredentialBuilder)((DeviceCodeCredentialBuilder)((DeviceCodeCredentialBuilder)new DeviceCodeCredentialBuilder().clientId(this.getClientId())).tenantId(config.getTenant())).additionallyAllowedTenants(new String[]{"*"}).tokenCachePersistenceOptions(this.getPersistenceOptions()).executorService(config.getExecutorService())).challengeConsumer(config.getDeviceCodeConsumer()).build();
    }

    @Override
    public AuthType getType() {
        return this.type;
    }
}

