/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.cli;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.zafarkhaja.semver.Version;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.cli.AzureCliSubscription;
import com.microsoft.azure.toolkit.lib.common.utils.CommandUtils;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AzureCliUtils {
    private static final String MIN_VERSION = "2.11.0";

    public static boolean isAppropriateCliInstalled() {
        try {
            String str = AzureCliUtils.executeAzureCli("az version --output json");
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            Map result = (Map)JsonUtils.fromJson((String)str, (TypeReference)typeRef);
            String cliVersion = (String)result.get("azure-cli");
            return Version.valueOf((String)cliVersion).greaterThanOrEqualTo(Version.valueOf((String)MIN_VERSION));
        }
        catch (NullPointerException | NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isSignedIn() {
        try {
            String str = AzureCliUtils.executeAzureCli("az account show --output json");
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            Map result = (Map)JsonUtils.fromJson((String)str, (TypeReference)typeRef);
            String subscriptionId = (String)result.get("id");
            return StringUtils.isNotBlank((CharSequence)subscriptionId);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Nonnull
    public static List<AzureCliSubscription> listSubscriptions() {
        String jsonString = AzureCliUtils.executeAzureCli("az account list --output json");
        AzureCliSubscription[] subscriptions = (AzureCliSubscription[])JsonUtils.fromJson((String)jsonString, AzureCliSubscription[].class);
        return Arrays.stream(subscriptions).filter(s -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s.getId(), s.getName()}) && s.getState().equalsIgnoreCase("Enabled")).filter(Utils.distinctByKey(t -> StringUtils.lowerCase((String)t.getId()))).collect(Collectors.toList());
    }

    @Nonnull
    public static String executeAzureCli(@Nonnull String command) {
        try {
            AzureConfiguration config = Azure.az().config();
            HashMap<String, String> env = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)config.getProxySource())) {
                String proxyAuthPrefix = "";
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getProxyUsername(), config.getProxyPassword()})) {
                    proxyAuthPrefix = config.getProxyUsername() + ":" + config.getProxyPassword() + "@";
                }
                String proxyStr = String.format("http://%s%s:%s", proxyAuthPrefix, config.getHttpProxyHost(), config.getHttpProxyPort());
                env.put("HTTPS_PROXY", proxyStr);
                env.put("HTTP_PROXY", proxyStr);
            }
            return CommandUtils.exec((String)command, env);
        }
        catch (IOException e) {
            throw new AzureToolkitAuthenticationException(String.format("execute Azure Cli command '%s' failed due to error: %s.", command, e.getMessage()));
        }
    }
}

