/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureTokenCredentialsAdapter;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AccountEntity;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public abstract class Account
implements IAccount {
    protected static final String TOOLKIT_TOKEN_CACHE_NAME = "azure-toolkit.cache";
    protected AccountEntity entity = new AccountEntity();
    protected boolean enablePersistence = false;
    protected TokenCredentialManager credentialManager;

    public abstract AuthType getAuthType();

    protected abstract String getClientId();

    public AzureEnvironment getEnvironment() {
        return this.entity == null ? null : this.entity.getEnvironment();
    }

    protected abstract Mono<Boolean> preLoginCheck();

    public TokenCredential getTokenCredentialForTenant(String tenantId) {
        this.requireAuthenticated();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new IllegalArgumentException("Should provide non-empty tenant id for retrieving credential.");
        }
        return this.credentialManager.createTokenCredentialForTenant(tenantId);
    }

    public AzureTokenCredentials getTokenCredentialForTenantV1(String tenantId) {
        this.requireAuthenticated();
        return AzureTokenCredentialsAdapter.from(this.getEnvironment(), tenantId, this.getTokenCredentialForTenant(tenantId));
    }

    public TokenCredential getTokenCredential(String subscriptionId) {
        this.requireAuthenticated();
        Subscription subscription = this.getSelectedSubscriptionById(subscriptionId);
        return this.getTokenCredentialForTenant(subscription.getTenantId());
    }

    public AzureTokenCredentials getTokenCredentialV1(String subscriptionId) {
        this.requireAuthenticated();
        Subscription subscription = this.getSelectedSubscriptionById(subscriptionId);
        return this.getTokenCredentialForTenantV1(subscription.getTenantId());
    }

    public void logout() {
        if (this.entity != null) {
            this.entity = null;
            ((AzureAccount)Azure.az(AzureAccount.class)).logout();
        }
    }

    public List<Subscription> getSubscriptions() {
        this.requireAuthenticated();
        return this.entity.getSubscriptions();
    }

    public List<Subscription> getSelectedSubscriptions() {
        this.requireAuthenticated();
        return this.entity.getSubscriptions().stream().filter(Subscription::isSelected).collect(Collectors.toList());
    }

    public void selectSubscription(List<String> selectedSubscriptionIds) {
        this.requireAuthenticated();
        if (CollectionUtils.isEmpty(selectedSubscriptionIds)) {
            throw new IllegalArgumentException("You must select at least one subscription.");
        }
        if (CollectionUtils.isEmpty(this.getSubscriptions())) {
            throw new IllegalArgumentException("There are no subscriptions to select.");
        }
        if (!this.entity.getSubscriptions().stream().anyMatch(s -> Utils.containsIgnoreCase((List)selectedSubscriptionIds, (String)s.getId()))) {
            throw new AzureToolkitAuthenticationException("Cannot select subscriptions since none subscriptions are selected, make sure you have provided valid subscription list");
        }
        Account.selectSubscriptionInner(this.getSubscriptions(), selectedSubscriptionIds);
    }

    private Mono<TokenCredentialManager> initializeTokenCredentialManager() {
        return this.createTokenCredentialManager().doOnSuccess(tokenCredentialManager -> {
            this.credentialManager = tokenCredentialManager;
        });
    }

    protected abstract Mono<TokenCredentialManager> createTokenCredentialManager();

    public Mono<Boolean> checkAvailable() {
        return this.preLoginCheck().doOnSuccess(avail -> this.entity.setAvailable((boolean)avail));
    }

    protected Mono<Account> login() {
        Mono<Boolean> mono = this.loginStep1();
        return mono.flatMap(ignore -> {
            if (this.entity.getSubscriptions() == null) {
                return this.credentialManager.listSubscriptions(this.entity.getTenantIds()).map(subscriptions -> {
                    this.entity.setTenantIds(subscriptions.stream().map(Subscription::getTenantId).distinct().collect(Collectors.toList()));
                    this.entity.setSubscriptions((List<Subscription>)subscriptions);
                    return true;
                });
            }
            return Mono.just((Object)true);
        }).map(ignore -> {
            this.finishLogin();
            return this;
        });
    }

    public Mono<Account> continueLogin() {
        ((AzureAccount)Azure.az(AzureAccount.class)).setAccount(this);
        return Mono.just((Object)this);
    }

    private void finishLogin() {
        Account.selectSubscriptionInner(this.getSubscriptions(), this.entity.getSelectedSubscriptionIds());
        if (this.getSelectedSubscriptions().isEmpty()) {
            this.getSubscriptions().forEach(subscription -> subscription.setSelected(true));
            this.entity.setSelectedSubscriptionIds(this.getSubscriptions().stream().map(Subscription::getId).collect(Collectors.toList()));
        }
    }

    private Mono<Boolean> loginStep1() {
        return this.checkAvailable().flatMap(ignore -> this.initializeTokenCredentialManager()).flatMap(TokenCredentialManager::listTenants).doOnSuccess(tenantIds -> {
            this.entity.setType(this.getAuthType());
            this.entity.setClientId(this.getClientId());
            if (this.entity.getTenantIds() == null) {
                this.entity.setTenantIds((List<String>)tenantIds);
            }
            if (StringUtils.isNotBlank((CharSequence)this.credentialManager.getEmail())) {
                this.entity.setEmail(this.credentialManager.getEmail());
            }
            this.entity.setEnvironment(this.credentialManager.getEnvironment());
        }).map(ignore -> {
            this.entity.setAvailable(true);
            return true;
        });
    }

    public String toString() {
        List<Subscription> selectedSubscriptions;
        ArrayList<String> details = new ArrayList<String>();
        if (!this.entity.isAvailable()) {
            return "<account not available>";
        }
        if (this.getAuthType() != null) {
            details.add(String.format("Auth type: %s", TextUtils.cyan((String)this.getAuthType().toString())));
        }
        if (this.entity.isAvailable() && CollectionUtils.isNotEmpty(this.getSubscriptions()) && (selectedSubscriptions = this.getSelectedSubscriptions()) != null && selectedSubscriptions.size() == 1) {
            details.add(String.format("Default subscription: %s(%s)", TextUtils.cyan((String)selectedSubscriptions.get(0).getName()), TextUtils.cyan((String)selectedSubscriptions.get(0).getId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getEntity().getEmail())) {
            details.add(String.format("Username: %s", TextUtils.cyan((String)this.getEntity().getEmail())));
        }
        return StringUtils.join((Object[])details.toArray(), (String)"\n");
    }

    private Subscription getSelectedSubscriptionById(String subscriptionId) {
        return this.getSelectedSubscriptions().stream().filter(s -> StringUtils.equalsIgnoreCase((CharSequence)subscriptionId, (CharSequence)s.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find subscription with id '%s'", subscriptionId)));
    }

    private static void selectSubscriptionInner(List<Subscription> subscriptions, List<String> subscriptionIds) {
        if (CollectionUtils.isNotEmpty(subscriptionIds) && CollectionUtils.isNotEmpty(subscriptions)) {
            subscriptions.forEach(s -> s.setSelected(Utils.containsIgnoreCase((List)subscriptionIds, (String)s.getId())));
        }
    }

    private void requireAuthenticated() {
        if (!this.entity.isAvailable()) {
            throw new AzureToolkitAuthenticationException("Account is not available.");
        }
        if (this.credentialManager == null || this.entity.getTenantIds() == null || this.entity.getSubscriptions() == null) {
            throw new AzureToolkitAuthenticationException("Please sign-in first.");
        }
    }

    public AccountEntity getEntity() {
        return this.entity;
    }

    void setEnablePersistence(boolean enablePersistence) {
        this.enablePersistence = enablePersistence;
    }

    protected boolean isEnablePersistence() {
        return this.enablePersistence;
    }
}

