/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.devicecode;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.DeviceCodeCredentialBuilder;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.TokenCachePersistenceOptions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.RefreshTokenTokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DeviceCodeAccount
extends Account {
    private static final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("azure-toolkit-auth-%d").build();
    private final ExecutorService executorService = DeviceCodeAccount.createExecutorService();
    private final CompletableFuture<DeviceCodeInfo> deviceCodeFuture = new CompletableFuture();
    private Mono<Account> loginMono;

    @Override
    public AuthType getAuthType() {
        return AuthType.DEVICE_CODE;
    }

    @Override
    public String getClientId() {
        return "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
    }

    @Override
    protected Mono<Boolean> preLoginCheck() {
        return Mono.just((Object)true);
    }

    @Override
    public Mono<Boolean> checkAvailable() {
        return Mono.just((Object)true);
    }

    @Override
    protected Mono<TokenCredentialManager> createTokenCredentialManager() {
        AzureEnvironment env = ((AzureCloud)Azure.az(AzureCloud.class)).getOrDefault();
        return RefreshTokenTokenCredentialManager.createTokenCredentialManager(env, this.getClientId(), this.createCredential(env));
    }

    @Override
    protected Mono<Account> login() {
        Mono map = Mono.fromFuture(this.deviceCodeFuture).map(ignore -> this);
        this.loginMono = super.login().subscribeOn(Schedulers.boundedElastic()).cache().doOnCancel(this.executorService::shutdownNow).doFinally(ignore -> this.executorService.shutdown());
        return map.doOnCancel(this.executorService::shutdownNow).doOnSubscribe(ignore -> this.loginMono.subscribe());
    }

    @Override
    public Mono<Account> continueLogin() {
        return this.loginMono.flatMap(ac -> super.continueLogin());
    }

    public DeviceCodeInfo getDeviceCode() {
        try {
            return this.deviceCodeFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AzureToolkitAuthenticationException(e.getMessage());
        }
    }

    private TokenCredential createCredential(AzureEnvironment env) {
        if (this.executorService.isShutdown()) {
            throw new AzureToolkitAuthenticationException("Cannot device login twice.");
        }
        AzureEnvironmentUtils.setupAzureEnvironment(env);
        DeviceCodeCredentialBuilder builder = new DeviceCodeCredentialBuilder();
        if (this.isEnablePersistence()) {
            builder.tokenCachePersistenceOptions(new TokenCachePersistenceOptions().setName("azure-toolkit.cache"));
        }
        return ((DeviceCodeCredentialBuilder)((DeviceCodeCredentialBuilder)builder.clientId("04b07795-8ddb-461a-bbee-02f9e1bf7b46")).executorService(this.executorService)).challengeConsumer(this.deviceCodeFuture::complete).build();
    }

    private static ExecutorService createExecutorService() {
        return Executors.newFixedThreadPool(2, namedThreadFactory);
    }
}

