/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.util;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.CoreUtils;
import com.azure.identity.CredentialUnavailableException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCliSubscription;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AzureCliUtils {
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private static final String WINDOWS_STARTER = "cmd.exe";
    private static final String LINUX_MAC_STARTER = "/bin/sh";
    private static final String WINDOWS_SWITCHER = "/c";
    private static final String LINUX_MAC_SWITCHER = "-c";
    private static final String DEFAULT_WINDOWS_SYSTEM_ROOT = System.getenv("SystemRoot");
    private static final String DEFAULT_MAC_LINUX_PATH = "/bin/";
    private static final String WINDOWS_PROCESS_ERROR_MESSAGE = "'az' is not recognized";
    private static final String LINUX_MAC_PROCESS_ERROR_MESSAGE = "(.*)az:(.*)not found";
    private static final String MIN_VERSION = "2.11.0";

    public static void ensureMinimumCliVersion() {
        try {
            JsonObject result = AzureCliUtils.executeAzCommandJson("az version --output json").getAsJsonObject();
            String cliVersion = result.get("azure-cli").getAsString();
            if (AzureCliUtils.compareWithMinimVersion(cliVersion) < 0) {
                throw new AzureToolkitAuthenticationException(String.format("Your azure cli version '%s' is too old, you need to upgrade your CLI with 'az upgrade'.", cliVersion));
            }
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new AzureToolkitAuthenticationException(String.format("Cannot authenticate through azure cli, please make sure your Azure cli is installed and signed-in, the detailed error is : %s", ex.getMessage()));
        }
    }

    private static int compareWithMinimVersion(String version) {
        int i;
        String[] v1s = version.split("\\.");
        String[] v2s = MIN_VERSION.split("\\.");
        for (i = 0; i < v1s.length && i < v2s.length && i < 3; ++i) {
            int v2;
            int v1 = Integer.parseInt(v1s[i]);
            if (v1 > (v2 = Integer.parseInt(v2s[i]))) {
                return 1;
            }
            if (v2 <= v1) continue;
            return -1;
        }
        if (i < v1s.length) {
            while (i < v1s.length) {
                if (Integer.parseInt(v1s[i]) != 0) {
                    return 1;
                }
                ++i;
            }
        }
        if (i < v2s.length) {
            while (i < v2s.length) {
                if (Integer.parseInt(v2s[i]) != 0) {
                    return -1;
                }
                ++i;
            }
        }
        return 0;
    }

    @Nonnull
    public static List<AzureCliSubscription> listSubscriptions() {
        JsonArray result = AzureCliUtils.executeAzCommandJson("az account list --output json").getAsJsonArray();
        ArrayList<AzureCliSubscription> list = new ArrayList<AzureCliSubscription>();
        if (result != null) {
            result.forEach(j -> {
                JsonObject accountObject = j.getAsJsonObject();
                if (!accountObject.has("id")) {
                    return;
                }
                String tenantId = accountObject.get("tenantId").getAsString();
                String subscriptionId = accountObject.get("id").getAsString();
                String subscriptionName = accountObject.get("name").getAsString();
                String state = accountObject.get("state").getAsString();
                String cloud = accountObject.get("cloudName").getAsString();
                String email = accountObject.get("user").getAsJsonObject().get("name").getAsString();
                if (StringUtils.equals((CharSequence)state, (CharSequence)"Enabled") && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{subscriptionId, subscriptionName})) {
                    AzureCliSubscription entity = new AzureCliSubscription();
                    entity.setId(subscriptionId);
                    entity.setName(subscriptionName);
                    entity.setSelected(accountObject.get("isDefault").getAsBoolean());
                    entity.setTenantId(tenantId);
                    entity.setEmail(email);
                    entity.setEnvironment(AzureEnvironmentUtils.stringToAzureEnvironment(cloud));
                    list.add(entity);
                }
            });
            return list;
        }
        throw new AzureToolkitAuthenticationException("Cannot list subscriptions by command `az account list`, please make sure you have signed in azure cli using `az login`");
    }

    /*
     * Loose catch block
     */
    public static JsonElement executeAzCommandJson(String command) {
        String processOutput;
        BufferedReader reader;
        block24: {
            String line;
            String switcher;
            String starter;
            reader = null;
            if (isWindows) {
                starter = WINDOWS_STARTER;
                switcher = WINDOWS_SWITCHER;
            } else {
                starter = LINUX_MAC_STARTER;
                switcher = LINUX_MAC_SWITCHER;
            }
            String commandWithMacPathFix = isWindows ? command : String.format("export PATH=$PATH:/usr/local/bin ; %s", command);
            ProcessBuilder builder = new ProcessBuilder(starter, switcher, commandWithMacPathFix);
            String workingDirectory = AzureCliUtils.getSafeWorkingDirectory();
            if (workingDirectory == null) {
                throw new IllegalStateException("A Safe Working directory could not be found to execute command from.");
            }
            builder.directory(new File(workingDirectory));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(WINDOWS_PROCESS_ERROR_MESSAGE) || line.matches(LINUX_MAC_PROCESS_ERROR_MESSAGE)) {
                    throw new CredentialUnavailableException("AzureCliTenantCredential authentication unavailable. Azure CLI not installed.");
                }
                output.append(line);
            }
            processOutput = StringUtils.replace((String)output.toString(), (String)"Argument '--tenant' is in preview. It may be changed/removed in a future release.", (String)"");
            process.waitFor(10L, TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (processOutput.length() > 0) {
                    String redactedOutput = AzureCliUtils.redactInfo(processOutput);
                    if (redactedOutput.contains("az login") || redactedOutput.contains("az account set")) {
                        throw new CredentialUnavailableException("AzureCliTenantCredential authentication unavailable. Please run 'az login' to set up account. Detailed error is: " + processOutput);
                    }
                    throw new ClientAuthenticationException(redactedOutput, null);
                }
                throw new ClientAuthenticationException("Failed to invoke Azure CLI ", null);
            }
            if (!StringUtils.startsWith((CharSequence)StringUtils.trim((String)processOutput), (CharSequence)"[")) break block24;
            JsonElement redactedOutput = (JsonElement)JsonUtils.getGson().fromJson(processOutput, JsonArray.class);
            return redactedOutput;
        }
        JsonElement redactedOutput = (JsonElement)JsonUtils.getGson().fromJson(processOutput, JsonObject.class);
        return redactedOutput;
        {
            catch (JsonParseException ex) {
                try {
                    throw new AzureToolkitAuthenticationException(String.format("Cannot execute command '%s', the output '%s' cannot be parsed as a JSON.", command, processOutput));
                }
                catch (IOException | InterruptedException e) {
                    throw new AzureToolkitAuthenticationException(e.getMessage());
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String getSafeWorkingDirectory() {
        if (isWindows) {
            if (CoreUtils.isNullOrEmpty((CharSequence)DEFAULT_WINDOWS_SYSTEM_ROOT)) {
                return null;
            }
            return DEFAULT_WINDOWS_SYSTEM_ROOT + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }

    private static String redactInfo(String input) {
        return input.replaceAll("\"accessToken\": \"(.*?)(\"|$)", "****");
    }
}

