/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.core.azurecli;

import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.TokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.core.azurecli.AzureCliTokenCredentialManager;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCliSubscription;
import com.microsoft.azure.toolkit.lib.auth.util.AzureCliUtils;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public class AzureCliAccount
extends Account {
    @Override
    public AuthType getAuthType() {
        return AuthType.AZURE_CLI;
    }

    @Override
    protected Mono<Boolean> preLoginCheck() {
        return Mono.fromCallable(() -> {
            AzureCliUtils.ensureMinimumCliVersion();
            AzureCliUtils.executeAzureCli("az account get-access-token --output json");
            List<AzureCliSubscription> subscriptions = AzureCliUtils.listSubscriptions();
            if (subscriptions.isEmpty()) {
                throw new AzureToolkitAuthenticationException("Cannot find any subscriptions in current account.");
            }
            AzureCliSubscription defaultSubscription = subscriptions.stream().filter(Subscription::isSelected).findFirst().orElse(subscriptions.get(0));
            AzureEnvironment configEnv = ((AzureCloud)Azure.az(AzureCloud.class)).get();
            if (configEnv != null && defaultSubscription.getEnvironment() != configEnv) {
                throw new AzureToolkitAuthenticationException(String.format("The azure cloud from azure cli '%s' doesn't match with your auth configuration, you can change it by executing 'az cloud set --name=%s' command to change the cloud in azure cli.", AzureEnvironmentUtils.getCloudNameForAzureCli(defaultSubscription.getEnvironment()), AzureEnvironmentUtils.getCloudNameForAzureCli(configEnv)));
            }
            this.entity.setEnvironment(defaultSubscription.getEnvironment());
            this.entity.setEmail(defaultSubscription.getEmail());
            subscriptions = subscriptions.stream().filter(s -> StringUtils.equals((CharSequence)this.entity.getEmail(), (CharSequence)s.getEmail())).collect(Collectors.toList());
            this.entity.setTenantIds(subscriptions.stream().map(Subscription::getTenantId).distinct().collect(Collectors.toList()));
            this.entity.setSubscriptions(subscriptions.stream().filter(Utils.distinctByKey(t -> StringUtils.lowerCase((String)t.getId()))).map(AzureCliAccount::toSubscription).collect(Collectors.toList()));
            this.entity.setSelectedSubscriptionIds(subscriptions.stream().filter(Subscription::isSelected).map(Subscription::getId).distinct().collect(Collectors.toList()));
            return true;
        });
    }

    @Override
    protected Mono<TokenCredentialManager> createTokenCredentialManager() {
        return Mono.just((Object)new AzureCliTokenCredentialManager(this.entity.getEnvironment()));
    }

    private static Subscription toSubscription(AzureCliSubscription s) {
        Subscription subscription = new Subscription();
        subscription.setId(s.getId());
        subscription.setName(s.getName());
        subscription.setSelected(s.isSelected());
        subscription.setTenantId(s.getTenantId());
        return subscription;
    }

    @Override
    public String getClientId() {
        return "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
    }
}

