/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.ServiceLoader;
import org.jetbrains.annotations.Nullable;

public class Azure {
    private final AzureConfiguration configuration = new AzureConfiguration();
    private static final Azure defaultInstance = new Azure();

    private Azure() {
    }

    public static synchronized <T extends AzureService> T az(Class<T> clazz) {
        T service = Azure.getService(clazz);
        if (service == null) {
            Holder.loader.reload();
            service = Azure.getService(clazz);
        }
        if (service != null) {
            return service;
        }
        throw new AzureToolkitRuntimeException(String.format("Azure service(%s) not supported", clazz.getSimpleName()));
    }

    @Nullable
    private static <T extends AzureService> T getService(Class<T> clazz) {
        for (AzureService service : Holder.loader) {
            if (!clazz.isInstance(service)) continue;
            return (T)((AzureService)clazz.cast(service));
        }
        return null;
    }

    public static Azure az() {
        return defaultInstance;
    }

    public AzureConfiguration config() {
        return this.configuration;
    }

    private static class Holder {
        private static final ServiceLoader<AzureService> loader = ServiceLoader.load(AzureService.class);

        private Holder() {
        }
    }
}

