/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.bundle;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureBundle;
import java.text.MessageFormat;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AzureString {
    @Nullable
    private final AzureBundle bundle;
    @Nonnull
    private final String name;
    @Nonnull
    private final Object[] params;

    @Nonnull
    public static AzureString fromString(@Nonnull String text) {
        return AzureString.format(text, new Object[0]);
    }

    @Nonnull
    public static AzureString format(@Nonnull String pattern, Object ... params) {
        return new AzureString(null, pattern, (Object[])ObjectUtils.firstNonNull((Object[])new Object[][]{params, new Object[0]}));
    }

    @Nonnull
    public static AzureString format(@Nonnull AzureBundle bundle, @Nonnull String key, Object ... params) {
        return new AzureString(bundle, key, (Object[])ObjectUtils.firstNonNull((Object[])new Object[][]{params, new Object[0]}));
    }

    public String getString() {
        return this.getString(this.params);
    }

    public String getString(Object ... params) {
        String pattern = Objects.nonNull(this.bundle) ? this.bundle.pattern(this.name) : this.name;
        try {
            if (StringUtils.isBlank((CharSequence)pattern)) {
                return String.format("!%s!", this.name);
            }
            if (pattern.contains("{0}")) {
                return MessageFormat.format(pattern, params);
            }
            return String.format(pattern, params);
        }
        catch (IllegalArgumentException e) {
            return pattern;
        }
    }

    public String toString() {
        return this.getString();
    }

    @Nullable
    public AzureBundle getBundle() {
        return this.bundle;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Object[] getParams() {
        return this.params;
    }

    public AzureString(@Nullable AzureBundle bundle, @Nonnull String name, @Nonnull Object[] params) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        this.bundle = bundle;
        this.name = name;
        this.params = params;
    }
}

