/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.database;

import com.microsoft.azure.toolkit.lib.common.entity.IAzureResourceEntity;
import com.microsoft.azure.toolkit.lib.common.utils.NetUtils;
import org.apache.commons.lang3.StringUtils;

public class FirewallRuleEntity
implements IAzureResourceEntity {
    private static final int MAX_FIREWALL_NAME_LENGTH = 128;
    public static final String ACCESS_FROM_AZURE_SERVICES_FIREWALL_RULE_NAME = "AllowAllWindowsAzureIps";
    public static final String IP_ALLOW_ACCESS_TO_AZURE_SERVICES = "0.0.0.0";
    private final String name;
    private final String id;
    private final String subscriptionId;
    private final String startIpAddress;
    private final String endIpAddress;

    public static String getAccessFromLocalFirewallRuleName() {
        String prefix = "ClientIPAddress_";
        String suffix = "_" + NetUtils.getMac();
        int maxHostnameLength = 128 - "ClientIPAddress_".length() - suffix.length();
        String hostname = NetUtils.getHostName().replaceAll("[^a-zA-Z0-9_-]", "");
        if (StringUtils.length((CharSequence)hostname) > maxHostnameLength) {
            hostname = StringUtils.substring((String)hostname, (int)0, (int)maxHostnameLength);
        }
        return "ClientIPAddress_" + hostname + suffix;
    }

    protected FirewallRuleEntity(FirewallRuleEntityBuilder<?, ?> b) {
        this.name = ((FirewallRuleEntityBuilder)b).name;
        this.id = ((FirewallRuleEntityBuilder)b).id;
        this.subscriptionId = ((FirewallRuleEntityBuilder)b).subscriptionId;
        this.startIpAddress = ((FirewallRuleEntityBuilder)b).startIpAddress;
        this.endIpAddress = ((FirewallRuleEntityBuilder)b).endIpAddress;
    }

    public static FirewallRuleEntityBuilder<?, ?> builder() {
        return new FirewallRuleEntityBuilderImpl();
    }

    public FirewallRuleEntityBuilder<?, ?> toBuilder() {
        return new FirewallRuleEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getStartIpAddress() {
        return this.startIpAddress;
    }

    public String getEndIpAddress() {
        return this.endIpAddress;
    }

    private static final class FirewallRuleEntityBuilderImpl
    extends FirewallRuleEntityBuilder<FirewallRuleEntity, FirewallRuleEntityBuilderImpl> {
        private FirewallRuleEntityBuilderImpl() {
        }

        @Override
        protected FirewallRuleEntityBuilderImpl self() {
            return this;
        }

        @Override
        public FirewallRuleEntity build() {
            return new FirewallRuleEntity(this);
        }
    }

    public static abstract class FirewallRuleEntityBuilder<C extends FirewallRuleEntity, B extends FirewallRuleEntityBuilder<C, B>> {
        private String name;
        private String id;
        private String subscriptionId;
        private String startIpAddress;
        private String endIpAddress;

        protected B $fillValuesFrom(C instance) {
            FirewallRuleEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(FirewallRuleEntity instance, FirewallRuleEntityBuilder<?, ?> b) {
            b.name(instance.name);
            b.id(instance.id);
            b.subscriptionId(instance.subscriptionId);
            b.startIpAddress(instance.startIpAddress);
            b.endIpAddress(instance.endIpAddress);
        }

        protected abstract B self();

        public abstract C build();

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this.self();
        }

        public B startIpAddress(String startIpAddress) {
            this.startIpAddress = startIpAddress;
            return this.self();
        }

        public B endIpAddress(String endIpAddress) {
            this.endIpAddress = endIpAddress;
            return this.self();
        }

        public String toString() {
            return "FirewallRuleEntity.FirewallRuleEntityBuilder(name=" + this.name + ", id=" + this.id + ", subscriptionId=" + this.subscriptionId + ", startIpAddress=" + this.startIpAddress + ", endIpAddress=" + this.endIpAddress + ")";
        }
    }
}

