/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.database;

import com.google.common.base.Preconditions;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public abstract class JdbcUrl {
    private static final int MYSQL_DEFAULT_PORT = 3306;
    private static final int SQL_SERVER_DEFAULT_PORT = 1433;
    protected final URIBuilder uri;
    private String username;
    private String password;

    private JdbcUrl(String url) {
        Preconditions.checkArgument((boolean)StringUtils.startsWith((CharSequence)url, (CharSequence)"jdbc:"), (Object)"invalid jdbc url.");
        try {
            this.uri = new URIBuilder(url.substring(5));
        }
        catch (URISyntaxException e) {
            throw new AzureToolkitRuntimeException("invalid jdbc url: %s", url);
        }
    }

    public static JdbcUrl from(String connectionString) {
        if (StringUtils.startsWith((CharSequence)connectionString, (CharSequence)"jdbc:mysql:")) {
            return new MySQLJdbcUrl(connectionString);
        }
        if (StringUtils.startsWith((CharSequence)connectionString, (CharSequence)"jdbc:sqlserver:")) {
            return new SQLServerJdbcUrl(connectionString);
        }
        throw new AzureToolkitRuntimeException("Unsupported jdbc url: %s", connectionString);
    }

    public static JdbcUrl mysql(String serverHost, String database) {
        return new MySQLJdbcUrl(String.format("jdbc:mysql://%s:%s/%s?serverTimezone=UTC&useSSL=true&requireSSL=false", JdbcUrl.encode(serverHost), 3306, JdbcUrl.encode(database)));
    }

    public static JdbcUrl mysql(String serverHost) {
        return new MySQLJdbcUrl(String.format("jdbc:mysql://%s:%s?serverTimezone=UTC&useSSL=true&requireSSL=false", JdbcUrl.encode(serverHost), 3306));
    }

    public static JdbcUrl sqlserver(String serverHost, String database) {
        return new SQLServerJdbcUrl(String.format("jdbc:sqlserver://%s:%s;encrypt=true;trustServerCertificate=false;loginTimeout=30;database=%s;", JdbcUrl.encode(serverHost), 1433, JdbcUrl.encode(database)));
    }

    public static JdbcUrl sqlserver(String serverHost) {
        return new SQLServerJdbcUrl(String.format("jdbc:sqlserver://%s:%s;encrypt=true;trustServerCertificate=false;loginTimeout=30;", JdbcUrl.encode(serverHost), 1433));
    }

    abstract int getDefaultPort();

    public int getPort() {
        if (this.uri.getPort() >= 0) {
            return this.uri.getPort();
        }
        return this.getDefaultPort();
    }

    public String getServerHost() {
        return JdbcUrl.decode(this.uri.getHost());
    }

    public String getDatabase() {
        String path = this.uri.getPath();
        return JdbcUrl.decode(StringUtils.startsWith((CharSequence)path, (CharSequence)"/") ? path.substring(1) : path);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public JdbcUrl setServerHost(String serverHost) {
        this.uri.setHost(serverHost);
        return this;
    }

    public JdbcUrl setDatabase(String database) {
        this.uri.setPath("/" + database);
        return this;
    }

    public JdbcUrl setUsername(String username) {
        this.username = username;
        return this;
    }

    public JdbcUrl setPassword(String password) {
        this.password = password;
        return this;
    }

    public JdbcUrl setPort(int port) {
        this.uri.setPort(port);
        return this;
    }

    public String toString() {
        String url = "jdbc:" + this.uri.toString();
        return JdbcUrl.decode(url);
    }

    private static String encode(String context) {
        try {
            return URLEncoder.encode(context, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AzureToolkitRuntimeException(e.getMessage());
        }
    }

    private static String decode(String context) {
        try {
            return URLDecoder.decode(context, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AzureToolkitRuntimeException(e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcUrl jdbcUrl = (JdbcUrl)o;
        return Objects.equals(this.uri.toString(), jdbcUrl.uri.toString());
    }

    public int hashCode() {
        return Objects.hash(this.uri.toString());
    }

    private static class SQLServerJdbcUrl
    extends JdbcUrl {
        private SQLServerJdbcUrl(String url) {
            super(StringUtils.replaceOnce((String)url, (String)";", (String)"?").replaceAll(";", "&"));
        }

        @Override
        int getDefaultPort() {
            return 1433;
        }

        @Override
        public JdbcUrl setDatabase(String database) {
            this.uri.setParameter("database", database);
            return this;
        }

        @Override
        public String getDatabase() {
            return this.uri.getQueryParams().stream().filter(e -> StringUtils.equals((CharSequence)e.getName(), (CharSequence)"database")).map(NameValuePair::getValue).findFirst().orElse(null);
        }

        @Override
        public String toString() {
            String url = "jdbc:" + StringUtils.replaceOnce((String)this.uri.toString(), (String)"?", (String)";").replaceAll("&", ";");
            return JdbcUrl.decode(url);
        }
    }

    private static class MySQLJdbcUrl
    extends JdbcUrl {
        private MySQLJdbcUrl(String url) {
            super(url);
        }

        @Override
        int getDefaultPort() {
            return 3306;
        }
    }
}

