/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.entity;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureResourceEntity;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;

public interface IAzureEntityManager<T extends IAzureResourceEntity> {
    public IAzureEntityManager<T> refresh();

    public boolean exists();

    public T entity();

    default public String name() {
        return this.entity().getName();
    }

    default public String id() {
        return this.entity().getId();
    }

    default public String subscriptionId() {
        return ResourceId.fromString((String)this.id()).subscriptionId();
    }

    default public String resourceGroup() {
        return ResourceId.fromString((String)this.id()).resourceGroupName();
    }

    default public Subscription subscription() {
        return Azure.az(IAzureAccount.class).account().getSubscription(this.subscriptionId());
    }
}

