/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.form;

import com.microsoft.azure.toolkit.lib.common.form.AzureValidationInfo;
import com.microsoft.azure.toolkit.lib.common.form.Validatable;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public interface AzureFormInput<T>
extends Validatable {
    public static final String MSG_REQUIRED = "This field is required.";

    public T getValue();

    public void setValue(T var1);

    @Override
    @Nonnull
    default public AzureValidationInfo doValidate() {
        T value = this.getValue();
        if (this.isRequired() && ObjectUtils.isEmpty(value)) {
            AzureValidationInfo.AzureValidationInfoBuilder builder = AzureValidationInfo.builder();
            String message = MSG_REQUIRED;
            if (!StringUtils.isEmpty((CharSequence)this.getLabel())) {
                message = String.format("\"%s\" is required.", this.getLabel());
            }
            return builder.message(message).input(this).type(AzureValidationInfo.Type.ERROR).build();
        }
        return Validatable.super.doValidate();
    }

    default public boolean isRequired() {
        return false;
    }

    default public String getLabel() {
        return "";
    }
}

