/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.management.exception.ManagementException;
import com.google.common.collect.Streams;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessage$AjcClosure1;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationException;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationRef;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureMessage
implements IAzureMessage {
    static final String DEFAULT_MESSAGE_TITLE = "Azure";
    @Nonnull
    protected final IAzureMessage.Type type;
    @Nonnull
    protected final AzureString message;
    @Nullable
    protected String title;
    @Nullable
    protected Object payload;
    @Nullable
    protected IAzureMessage.Action[] actions;
    protected IAzureMessage.ValueDecorator valueDecorator;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @Nonnull
    public String getContent() {
        if (!(this.getPayload() instanceof Throwable)) {
            return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.decorateText(this.message, null), this.message.getString()});
        }
        Throwable throwable = (Throwable)this.getPayload();
        List<IAzureOperation> operations = this.getOperations();
        String failure = operations.stream().findFirst().map(IAzureOperation::getTitle).map(azureString -> "Failed to " + this.decorateText((AzureString)azureString, azureString::getString)).orElse("Failed to proceed");
        String cause = Optional.ofNullable(this.getCause(throwable)).map(StringUtils::uncapitalize).map(c -> "," + (c.endsWith(".") ? c : c + '.')).orElse("");
        String errorAction = Optional.ofNullable(this.getErrorAction(throwable)).map(StringUtils::capitalize).map(c -> System.lineSeparator() + (c.endsWith(".") ? c : c + '.')).orElse("");
        return failure + cause + errorAction;
    }

    public String getDetails() {
        List<IAzureOperation> operations = this.getOperations();
        return operations.size() < 2 ? "" : operations.stream().map(this::getDetailItem).collect(Collectors.joining("", "", ""));
    }

    protected String getDetailItem(IAzureOperation o) {
        return Optional.ofNullable(o.getTitle()).map(t -> this.decorateText((AzureString)t, t::getString)).map(StringUtils::capitalize).map(t -> String.format("\u25cf %s", t)).orElse(null);
    }

    @Override
    @Nullable
    public String decorateValue(@Nonnull Object p, @Nullable Supplier<String> dft) {
        String result = IAzureMessage.super.decorateValue(p, null);
        if (Objects.isNull(result) && Objects.nonNull(this.valueDecorator)) {
            result = this.valueDecorator.decorateValue(p, this);
        }
        return Objects.isNull(result) && Objects.nonNull(dft) ? dft.get() : result;
    }

    @Nullable
    protected String getCause(@Nonnull Throwable throwable) {
        Throwable root = AzureMessage.getRecognizableCause(throwable);
        if (Objects.isNull(root)) {
            return ExceptionUtils.getRootCause((Throwable)throwable).toString();
        }
        String cause = null;
        if (root instanceof ManagementException) {
            cause = ((ManagementException)root).getValue().getMessage();
        } else if (root instanceof HttpResponseException) {
            cause = (String)((HttpResponseException)root).getResponse().getBodyAsString().block();
        }
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{cause, root.getMessage()});
    }

    @Nullable
    private static Throwable getRecognizableCause(@Nonnull Throwable throwable) {
        List throwables = ExceptionUtils.getThrowableList((Throwable)throwable);
        for (int i = throwables.size() - 1; i >= 0; --i) {
            String rootClassName;
            Throwable t = (Throwable)throwables.get(i);
            if (t instanceof AzureOperationException || !(rootClassName = t.getClass().getName()).startsWith("com.microsoft") && !rootClassName.startsWith("com.azure")) continue;
            return t;
        }
        return null;
    }

    @Nullable
    protected String getErrorAction(@Nonnull Throwable throwable) {
        return ExceptionUtils.getThrowableList((Throwable)throwable).stream().filter(t -> t instanceof AzureToolkitRuntimeException || t instanceof AzureToolkitException).map(t -> t instanceof AzureToolkitRuntimeException ? ((AzureToolkitRuntimeException)t).getAction() : ((AzureToolkitException)t).getAction()).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }

    @Nonnull
    @Cacheable(cacheName="message/operations", key="${this.hashCode()}")
    protected List<IAzureOperation> getOperations() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AzureMessage$AjcClosure1 azureMessage$AjcClosure1 = new AzureMessage$AjcClosure1(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureMessage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Nonnull
    private static List<IAzureOperation> getContextOperations() {
        LinkedList<IAzureOperation> result = new LinkedList<IAzureOperation>();
        IAzureOperation current = AzureTaskContext.current().currentOperation();
        while (Objects.nonNull(current)) {
            if (current instanceof AzureOperationRef) {
                result.addFirst(current);
                AzureOperation annotation = ((AzureOperationRef)current).getAnnotation(AzureOperation.class);
                if (annotation.type() == AzureOperation.Type.ACTION) break;
            }
            current = current.getParent();
        }
        return result;
    }

    @Nonnull
    private static List<IAzureOperation> getExceptionOperations(@Nonnull Throwable throwable) {
        return ExceptionUtils.getThrowableList((Throwable)throwable).stream().filter(object -> object instanceof AzureOperationException).map(o -> ((AzureOperationException)o).getOperation()).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public String getTitle() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.title, DEFAULT_MESSAGE_TITLE});
    }

    @Override
    @Nonnull
    public IAzureMessage.Action[] getActions() {
        return (IAzureMessage.Action[])ObjectUtils.firstNonNull((Object[])new IAzureMessage.Action[][]{this.actions, new IAzureMessage.Action[0]});
    }

    @Nonnull
    public static Context getContext() {
        return AzureMessage.getContext(IAzureOperation.current());
    }

    @Nonnull
    public static Context getActionContext() {
        IAzureOperation operation = IAzureOperation.current();
        return Optional.ofNullable(operation).map(IAzureOperation::getActionParent).map(AzureMessage::getContext).orElse(new Context(operation));
    }

    @Nonnull
    public static Context getContext(@Nullable IAzureOperation operation) {
        return Optional.ofNullable(operation).map(o -> o.get(Context.class, new Context(operation))).orElse(new Context(operation));
    }

    public AzureMessage(@Nonnull IAzureMessage.Type type, @Nonnull AzureString message) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.type = type;
        this.message = message;
    }

    @Override
    @Nonnull
    public IAzureMessage.Type getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public AzureString getMessage() {
        return this.message;
    }

    @Override
    @Nullable
    public Object getPayload() {
        return this.payload;
    }

    public IAzureMessage.ValueDecorator getValueDecorator() {
        return this.valueDecorator;
    }

    public AzureMessage setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public AzureMessage setPayload(@Nullable Object payload) {
        this.payload = payload;
        return this;
    }

    public AzureMessage setActions(@Nullable IAzureMessage.Action[] actions) {
        this.actions = actions;
        return this;
    }

    public AzureMessage setValueDecorator(IAzureMessage.ValueDecorator valueDecorator) {
        this.valueDecorator = valueDecorator;
        return this;
    }

    static {
        AzureMessage.ajc$preClinit();
    }

    static final /* synthetic */ List getOperations_aroundBody0(AzureMessage ajc$this, JoinPoint joinPoint) {
        List<IAzureOperation> contextOperations = AzureMessage.getContextOperations();
        List exceptionOperations = Optional.ofNullable(ajc$this.getPayload()).filter(p -> p instanceof Throwable).map(p -> AzureMessage.getExceptionOperations((Throwable)p)).orElse(new ArrayList());
        HashMap operations = new HashMap();
        Streams.concat((Stream[])new Stream[]{contextOperations.stream(), exceptionOperations.stream()}).filter(o -> !operations.containsKey(o.getName())).forEachOrdered(o -> operations.put(o.getName(), o));
        return new ArrayList(operations.values());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureMessage.java", AzureMessage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getOperations", "com.microsoft.azure.toolkit.lib.common.messager.AzureMessage", "", "", "", "java.util.List"), 147);
    }

    public static class Context
    implements IAzureOperation.IContext {
        @Nullable
        private final IAzureOperation operation;
        private IAzureMessager messager = null;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public void setProperty(@Nonnull String key, Object val) {
            this.properties.put(key, val);
        }

        public Object getProperty(@Nonnull String key) {
            return this.properties.get(key);
        }

        public void setMessager(@Nonnull IAzureMessager messager) {
            this.messager = messager;
        }

        @Nonnull
        public IAzureMessager getMessager() {
            if (Objects.nonNull(this.messager)) {
                return this.messager;
            }
            return this.getMessager(Optional.ofNullable(this.operation).map(IAzureOperation::getParent).orElse(null));
        }

        @Nonnull
        public IAzureMessager getActionMessager() {
            return this.getMessager(Optional.ofNullable(this.operation).map(IAzureOperation::getActionParent).orElse(null));
        }

        @Nonnull
        private IAzureMessager getMessager(@Nullable IAzureOperation op) {
            return Optional.ofNullable(op).map(AzureMessage::getContext).map(Context::getMessager).orElse(AzureMessager.getDefaultMessager());
        }

        public Context(@Nullable IAzureOperation operation) {
            this.operation = operation;
        }
    }
}

