/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.task;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureTaskContext {
    private static final Logger log = Logger.getLogger(AzureTaskContext.class.getName());
    private static final ThreadLocal<AzureTaskContext> context = new ThreadLocal();
    protected long threadId;
    @Nullable
    protected IAzureOperation operation;
    @Nullable
    protected AzureTaskContext parent;
    @Nullable
    private AzureTask<?> task;

    private AzureTaskContext(@Nullable AzureTaskContext parent) {
        this.operation = Optional.ofNullable(parent).map(p -> p.operation).orElse(null);
        this.threadId = -1L;
        this.parent = parent;
    }

    @Nonnull
    public static AzureTaskContext current() {
        AzureTaskContext ctxNode = context.get();
        if (Objects.isNull(ctxNode)) {
            ctxNode = new AzureTaskContext(null);
            context.set(ctxNode);
        }
        return ctxNode;
    }

    @Nullable
    public IAzureOperation currentOperation() {
        return this.operation;
    }

    public void pushOperation(IAzureOperation operation) {
        if (Objects.isNull(this.parent) && Objects.isNull(this.operation)) {
            log.fine(String.format("orphan context[%s] is setup", this));
        }
        operation.setParent(this.operation);
        this.operation = operation;
    }

    @Nullable
    public IAzureOperation popOperation() {
        IAzureOperation popped = this.operation;
        assert (popped != null) : "popped operation is null";
        this.operation = popped.getParent();
        if (Objects.isNull(this.parent) && Objects.isNull(this.operation)) {
            context.remove();
            log.fine(String.format("orphan context[%s] is disposed", this));
        }
        return popped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Runnable runnable, AzureTaskContext context) {
        try {
            context.setup();
            Optional.ofNullable(context.getTask()).ifPresent(task -> {
                AzureTelemeter.beforeEnter(task);
                AzureTaskContext.current().pushOperation((IAzureOperation)task);
            });
            runnable.run();
            Optional.ofNullable(context.getTask()).ifPresent(task -> {
                IAzureOperation popped = AzureTaskContext.current().popOperation();
                AzureTelemeter.afterExit(task);
                assert (Objects.equals(task, popped)) : String.format("popped op[%s] is not the exiting async task[%s]", popped, task);
            });
        }
        catch (Throwable throwable) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
            if (!(rootCause instanceof InterruptedIOException) && !(rootCause instanceof InterruptedException)) {
                AzureMessager.getMessager().error(throwable);
            }
            Optional.ofNullable(context.getTask()).ifPresent(task -> {
                IAzureOperation popped = AzureTaskContext.current().popOperation();
                AzureTelemeter.onError(task, throwable);
                assert (Objects.equals(task, popped)) : String.format("popped op[%s] is not the task[%s] throwing exception", popped, task);
            });
        }
        finally {
            context.dispose();
        }
    }

    @Nonnull
    AzureTaskContext derive() {
        long threadId = Thread.currentThread().getId();
        AzureTaskContext current = AzureTaskContext.current();
        assert (this == current) : String.format("[threadId:%s] deriving context from context[%s] in context[%s].", threadId, this, current);
        this.threadId = this.threadId > 0L ? this.threadId : threadId;
        return new AzureTaskContext(this);
    }

    private void setup() {
        AzureTaskContext current = AzureTaskContext.current();
        long threadId = Thread.currentThread().getId();
        assert (current.threadId == -1L || current.threadId == threadId) : String.format("[threadId:%s] illegal thread context[%s]", threadId, current);
        this.threadId = threadId;
        this.parent = current;
        context.set(this);
    }

    private void dispose() {
        AzureTaskContext current = AzureTaskContext.current();
        long threadId = Thread.currentThread().getId();
        assert (this == current && this.threadId == threadId) : String.format("[threadId:%s] disposing context[%s] in context[%s].", threadId, this, current);
        if (this.parent == null || this.threadId != this.parent.threadId) {
            context.remove();
        } else {
            context.set(this.parent);
        }
    }

    public String getId() {
        return Utils.getId(this);
    }

    public String toString() {
        String id = this.getId();
        String prId = Optional.ofNullable(this.parent).map(AzureTaskContext::getId).orElse("/");
        return String.format("{id: %s, threadId:%s, parent:%s}", id, this.threadId, prId);
    }

    @Nullable
    public AzureTaskContext getParent() {
        return this.parent;
    }

    @Nullable
    public AzureTask<?> getTask() {
        return this.task;
    }

    void setTask(@Nullable AzureTask<?> task) {
        this.task = task;
    }
}

