/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscription;
import rx.schedulers.Schedulers;

public class TailingDebouncer
implements Debouncer {
    private final Runnable debounced;
    private final int delay;
    private Subscription timer;

    public TailingDebouncer(Runnable debounced, int delayInMillis) {
        this.debounced = debounced;
        this.delay = delayInMillis;
    }

    @Override
    public synchronized void debounce() {
        if (this.isPending()) {
            this.timer.unsubscribe();
        }
        this.timer = Observable.timer((long)this.delay, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).subscribe(ignore -> {
            this.debounced.run();
            this.timer = null;
        }, e -> {
            this.timer = null;
        });
    }

    @Override
    public synchronized boolean isPending() {
        return Objects.nonNull(this.timer) && !this.timer.isUnsubscribed();
    }
}

