/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.validator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.validator.ValidationMessage;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class SchemaValidator {
    private final Map<String, JsonSchema> schemaMap = new HashMap<String, JsonSchema>();
    private final JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
    private final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS, MapperFeature.AUTO_DETECT_GETTERS, MapperFeature.AUTO_DETECT_IS_GETTERS});

    private SchemaValidator() {
        Set resources = new Reflections("schema", new Scanner[]{new ResourcesScanner()}).getResources(Pattern.compile(".*\\.json"));
        resources.stream().map(resource -> Pair.of((Object)resource, (Object)SchemaValidator.class.getResourceAsStream("/" + resource))).filter(pair -> pair.getValue() != null).forEach(pair -> this.registerSchema(FilenameUtils.getBaseName((String)((String)pair.getKey())), (InputStream)pair.getValue()));
    }

    public static SchemaValidator getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void registerSchema(@Nonnull String schemaId, @Nonnull JsonNode schema) {
        if (this.schemaMap.containsKey(schemaId)) {
            AzureMessager.getMessager().info(AzureString.format("Updating schema for %s", schemaId));
        }
        this.schemaMap.put(schemaId, this.factory.getSchema(schema));
    }

    public void registerSchema(@Nonnull String schemaId, @Nonnull InputStream schema) {
        try (InputStream inputStream = schema;){
            JsonNode schemaNode = this.objectMapper.readTree(inputStream);
            this.registerSchema(schemaId, schemaNode);
        }
        catch (IOException e) {
            AzureMessager.getMessager().warning(AzureString.format("Failed to load configuration schema %s", schemaId));
        }
    }

    public List<ValidationMessage> validate(@Nonnull String schemaId, @Nonnull Object value) {
        return this.validate(schemaId, value, "$");
    }

    public List<ValidationMessage> validate(@Nonnull String schemaId, @Nonnull Object value, @Nullable String pathPrefix) {
        return this.validate(schemaId, (JsonNode)this.objectMapper.convertValue(value, JsonNode.class), pathPrefix);
    }

    public List<ValidationMessage> validate(@Nonnull String schemaId, @Nonnull JsonNode value) {
        return this.validate(schemaId, value, "$");
    }

    public List<ValidationMessage> validate(@Nonnull String schemaId, @Nonnull JsonNode value, @Nullable String pathPrefix) {
        if (!this.schemaMap.containsKey(schemaId)) {
            AzureMessager.getMessager().warning(AzureString.format("Skip validation as schema %s was not registered", schemaId));
            return Collections.emptyList();
        }
        return this.validate(this.schemaMap.get(schemaId), value, pathPrefix);
    }

    private List<ValidationMessage> validate(@Nonnull JsonSchema schema, @Nonnull JsonNode value, @Nullable String pathPrefix) {
        return schema.validate(value, value, pathPrefix).stream().map(ValidationMessage::fromRawMessage).collect(Collectors.toList());
    }

    private static class LazyHolder {
        static final SchemaValidator INSTANCE = new SchemaValidator();

        private LazyHolder() {
        }
    }
}

