/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ProviderResourceType;
import com.azure.resourcemanager.resources.models.Providers;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService$AjcClosure1;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureBaseResource;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureModule;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public interface AzureService<T extends IAzureBaseResource>
extends IAzureModule<T, IAzureBaseResource> {
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    default public List<Subscription> getSubscriptions() {
        return Azure.az(IAzureAccount.class).account().getSelectedSubscriptions();
    }

    default public List<Region> listSupportedRegions(String subscriptionId) {
        String[] names = StringUtils.split((String)this.name(), (String)"/");
        if (names.length != 2) {
            throw new AzureToolkitRuntimeException(String.format("It is illegal to list regions for service '%s'.", this.name()));
        }
        String provider = names[0];
        String resourceType = names[1];
        List<Region> allRegionList = Azure.az(IAzureAccount.class).listRegions(subscriptionId);
        ArrayList<Region> result = new ArrayList<Region>();
        ResourceManager resourceManager = this.getResourceManager(subscriptionId);
        ((Provider)resourceManager.providers().getByName(provider)).resourceTypes().stream().filter(type -> StringUtils.equalsIgnoreCase((CharSequence)type.resourceType(), (CharSequence)resourceType)).findAny().map(ProviderResourceType::locations).ifPresent(list -> {
            List regionListByResource = list.stream().map(Region::fromName).collect(Collectors.toList());
            result.addAll(CollectionUtils.intersection(regionListByResource, (Iterable)allRegionList));
        });
        return result.isEmpty() ? allRegionList : result;
    }

    @Cacheable(cacheName="resource/{}/manager", key="$subscriptionId")
    default public ResourceManager getResourceManager(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureService$AjcClosure1 azureService$AjcClosure1 = new AzureService$AjcClosure1(objectArray);
        return (ResourceManager)CacheManager.aspectOf().aroundCacheable(azureService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public static HttpPipelinePolicy getUserAgentPolicy(String userAgent) {
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }

    static {
        Factory factory = new Factory("AzureService.java", AzureService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResourceManager", "com.microsoft.azure.toolkit.lib.AzureService", "java.lang.String", "subscriptionId", "", "com.azure.resourcemanager.resources.ResourceManager"), 60);
    }

    public static /* synthetic */ ResourceManager getResourceManager_aroundBody0(AzureService ajc$this, String subscriptionId, JoinPoint joinPoint) {
        IAccount account = Azure.az(IAzureAccount.class).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logDetailLevel = config.getLogLevel() == null ? HttpLogDetailLevel.NONE : HttpLogDetailLevel.valueOf((String)config.getLogLevel());
        AzureProfile azureProfile = new AzureProfile(account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)ResourceManager.configure().withPolicy(AzureService.getUserAgentPolicy(userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ((ResourceManager.Configurable)((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withLogLevel(logDetailLevel)).withPolicy(AzureService.getUserAgentPolicy(userAgent))).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId);
    }
}

