/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.ActionGroup;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class AzureActionManager {
    private static AzureActionManager instance;

    protected static void register(AzureActionManager manager) {
        if (instance != null) {
            AzureMessager.getDefaultMessager().warning("ActionManager is already registered", null);
            return;
        }
        instance = manager;
    }

    public abstract <D> void registerAction(Action.Id<D> var1, Action<D> var2);

    public <D> void registerAction(Action.Id<D> id, Consumer<D> action) {
        this.registerAction(id, new Action<D>(action));
    }

    public abstract <D> Action<D> getAction(Action.Id<D> var1);

    public abstract void registerGroup(String var1, ActionGroup var2);

    public abstract ActionGroup getGroup(String var1);

    public <D> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull Predicate<D> condition, @Nonnull Consumer<D> handler) {
        Action<D> action = this.getAction(id);
        action.registerHandler(condition, handler);
    }

    public <D, E> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull BiPredicate<D, E> condition, @Nonnull BiConsumer<D, E> handler) {
        Action<D> action = this.getAction(id);
        action.registerHandler(condition, handler);
    }

    public static AzureActionManager getInstance() {
        return instance;
    }
}

