/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.bundle;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureBundle$AjcClosure1;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureBundle {
    private static final Map<String, Optional<ResourceBundle>> bundles;
    private static final String INDEX = "index";
    private final String pkg;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Nonnull
    public AzureString text(@Nonnull String key, Object ... params) {
        return AzureString.format(this, key, params);
    }

    @Nonnull
    public String message(@Nonnull String key, Object ... params) {
        return AzureBundle.message(this.pkg, key, params);
    }

    @Nullable
    public String pattern(@Nonnull String key) {
        return AzureBundle.pattern(this.pkg, key);
    }

    @Nonnull
    public static AzureString text(@Nonnull String pkg, @Nonnull String key, Object ... params) {
        return AzureString.format(new AzureBundle(pkg), key, params);
    }

    @Nonnull
    public static String message(@Nonnull String pkg, @Nonnull String key, Object ... params) {
        String pattern = AzureBundle.pattern(pkg, key);
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return String.format("!%s!", key);
        }
        try {
            return MessageFormat.format(pattern, params);
        }
        catch (IllegalArgumentException e) {
            return pattern;
        }
    }

    @Nullable
    @Cacheable(cacheName="bundle/package/{}/pattern/{}", key="$pkg/$key")
    public static String pattern(@Nonnull String pkg, @Nonnull String key) {
        String string = pkg;
        String string2 = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{string, string2, joinPoint};
        AzureBundle$AjcClosure1 azureBundle$AjcClosure1 = new AzureBundle$AjcClosure1(objectArray);
        return (String)CacheManager.aspectOf().aroundCacheable(azureBundle$AjcClosure1.linkClosureAndJoinPoint(65536));
    }

    private static List<ResourceBundle> getBundles(@Nonnull String pkg, @Nonnull String key) {
        String supClass = key.split("[|.]")[0].toLowerCase();
        String subClass = key.split("\\.")[0].replaceAll("\\|", "_").toLowerCase();
        String exSub = String.format("%s.%s", pkg, subClass);
        String exSup = String.format("%s.%s", pkg, supClass);
        String exIdx = String.format("%s.%s", pkg, INDEX);
        String ideSub = String.format("%s.ide.%s", pkg, subClass);
        String ideSup = String.format("%s.ide.%s", pkg, supClass);
        String ideIdx = String.format("%s.ide.%s", pkg, INDEX);
        String sub = String.format("%s.base.%s", pkg, subClass);
        String sup = String.format("%s.base.%s", pkg, supClass);
        String idx = String.format("%s.base.%s", pkg, INDEX);
        return Stream.of(exSub, exSup, exIdx, ideSub, ideSup, ideIdx, sub, sup, idx).map(fqn -> bundles.computeIfAbsent((String)fqn, k -> Optional.ofNullable(AzureBundle.getBundle(fqn)))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Nullable
    private static String getPattern(@Nonnull String key, @Nullable ResourceBundle bundle) {
        if (StringUtils.isBlank((CharSequence)key) || Objects.isNull(bundle)) {
            return null;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    @Nullable
    private static ResourceBundle getBundle(String bundleName) {
        try {
            return ResourceBundle.getBundle(bundleName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AzureBundle(String pkg) {
        this.pkg = pkg;
    }

    static {
        AzureBundle.ajc$preClinit();
        bundles = new ConcurrentHashMap<String, Optional<ResourceBundle>>();
    }

    static final /* synthetic */ String pattern_aroundBody0(String pkg, String key, JoinPoint joinPoint) {
        List<ResourceBundle> pkgBundles = AzureBundle.getBundles(pkg, key);
        for (ResourceBundle bundle : pkgBundles) {
            String pattern = AzureBundle.getPattern(key, bundle);
            if (!Objects.nonNull(pattern)) continue;
            return pattern;
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureBundle.java", AzureBundle.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "pattern", "com.microsoft.azure.toolkit.lib.common.bundle.AzureBundle", "java.lang.String:java.lang.String", "pkg:key", "", "java.lang.String"), 67);
    }
}

