/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.entity.IAzureBaseResource;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.event.AzureOperationEvent;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationException;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationRef;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskContext;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import java.util.Objects;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class AzureOperationAspect {
    private static final Logger log = Logger.getLogger(AzureOperationAspect.class.getName());
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ AzureOperationAspect ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.operation.AzureOperation * *..*.*(..))")
    public void operation() {
    }

    @Before(value="operation()")
    public void beforeEnter(JoinPoint point) {
        AzureOperationRef operation = AzureOperationAspect.toOperationRef(point);
        AzureTelemeter.beforeEnter(operation);
        AzureTaskContext.current().pushOperation(operation);
        Object source = point.getThis();
        if (source instanceof AzureOperationEvent.Source) {
            AzureOperationEvent.Source target = ((AzureOperationEvent.Source)source).getEventSource();
            AzureOperationEvent event = new AzureOperationEvent(target, operation, AzureOperationEvent.Stage.BEFORE);
            AzureEventBus.emit(operation.getName(), event);
        }
    }

    @AfterReturning(value="operation()")
    public void afterReturning(JoinPoint point) {
        AzureOperationRef current = AzureOperationAspect.toOperationRef(point);
        AzureOperationRef operation = (AzureOperationRef)AzureTaskContext.current().popOperation();
        assert (Objects.nonNull(operation) && operation.getMethod().equals(current.getMethod())) : String.format("popped operation[%s] is not the exiting operation[%s]", current, operation);
        AzureTelemeter.afterExit(operation);
        Object source = point.getThis();
        if (source instanceof AzureOperationEvent.Source) {
            AzureOperationEvent.Source target = ((AzureOperationEvent.Source)source).getEventSource();
            AzureOperationEvent event = new AzureOperationEvent(target, operation, AzureOperationEvent.Stage.AFTER);
            AzureEventBus.emit(operation.getName(), event);
        }
    }

    @AfterThrowing(pointcut="operation()", throwing="e")
    public void afterThrowing(JoinPoint point, Throwable e) throws Throwable {
        AzureOperationRef current = AzureOperationAspect.toOperationRef(point);
        AzureOperationRef operation = (AzureOperationRef)AzureTaskContext.current().popOperation();
        assert (Objects.nonNull(operation) && operation.getMethod().equals(current.getMethod())) : String.format("popped operation[%s] is not the operation[%s] throwing exception", current, operation);
        AzureTelemeter.onError(operation, e);
        Object source = point.getThis();
        if (source instanceof AzureOperationEvent.Source) {
            AzureOperationEvent.Source target = ((AzureOperationEvent.Source)source).getEventSource();
            AzureOperationEvent event = new AzureOperationEvent(target, operation, AzureOperationEvent.Stage.ERROR);
            AzureEventBus.emit(operation.getName(), event);
        }
        if (source instanceof IAzureBaseResource) {
            ((IAzureBaseResource)source).refresh();
        }
        if (!(e instanceof RuntimeException)) {
            throw e;
        }
        throw new AzureOperationException((IAzureOperation)operation, e);
    }

    private static AzureOperationRef toOperationRef(JoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Object[] args = point.getArgs();
        Object instance = point.getThis();
        return ((AzureOperationRef.AzureOperationRefBuilder)((AzureOperationRef.AzureOperationRefBuilder)((AzureOperationRef.AzureOperationRefBuilder)((AzureOperationRef.AzureOperationRefBuilder)AzureOperationRef.builder().instance(instance)).method(signature.getMethod())).paramNames(signature.getParameterNames())).paramValues(args)).build();
    }

    static {
        try {
            AzureOperationAspect.ajc$perSingletonInstance = new AzureOperationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static AzureOperationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

