/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils.aspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class MethodInvocation {
    protected final Method method;
    protected final String[] paramNames;
    protected final Object[] paramValues;
    protected final Object instance;

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation operation = (MethodInvocation)obj;
        return Objects.equals(operation.getMethod(), this.getMethod());
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.method.getAnnotation(annotation);
    }

    public static MethodInvocation from(@Nonnull JoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Object[] args = point.getArgs();
        Object instance = point.getThis();
        return ((MethodInvocationBuilder)((MethodInvocationBuilder)((MethodInvocationBuilder)((MethodInvocationBuilder)MethodInvocation.builder().instance(instance)).method(signature.getMethod())).paramNames(signature.getParameterNames())).paramValues(args)).build();
    }

    protected MethodInvocation(MethodInvocationBuilder<?, ?> b) {
        this.method = ((MethodInvocationBuilder)b).method;
        this.paramNames = ((MethodInvocationBuilder)b).paramNames;
        this.paramValues = ((MethodInvocationBuilder)b).paramValues;
        this.instance = ((MethodInvocationBuilder)b).instance;
    }

    public static MethodInvocationBuilder<?, ?> builder() {
        return new MethodInvocationBuilderImpl();
    }

    public Method getMethod() {
        return this.method;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public Object[] getParamValues() {
        return this.paramValues;
    }

    public Object getInstance() {
        return this.instance;
    }

    private static final class MethodInvocationBuilderImpl
    extends MethodInvocationBuilder<MethodInvocation, MethodInvocationBuilderImpl> {
        private MethodInvocationBuilderImpl() {
        }

        @Override
        protected MethodInvocationBuilderImpl self() {
            return this;
        }

        @Override
        public MethodInvocation build() {
            return new MethodInvocation(this);
        }
    }

    public static abstract class MethodInvocationBuilder<C extends MethodInvocation, B extends MethodInvocationBuilder<C, B>> {
        private Method method;
        private String[] paramNames;
        private Object[] paramValues;
        private Object instance;

        protected abstract B self();

        public abstract C build();

        public B method(Method method) {
            this.method = method;
            return this.self();
        }

        public B paramNames(String[] paramNames) {
            this.paramNames = paramNames;
            return this.self();
        }

        public B paramValues(Object[] paramValues) {
            this.paramValues = paramValues;
            return this.self();
        }

        public B instance(Object instance) {
            this.instance = instance;
            return this.self();
        }

        public String toString() {
            return "MethodInvocation.MethodInvocationBuilder(method=" + this.method + ", paramNames=" + Arrays.deepToString(this.paramNames) + ", paramValues=" + Arrays.deepToString(this.paramValues) + ", instance=" + this.instance + ")";
        }
    }
}

