/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.SubscriptionScoped;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.Preload;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureBaseResource;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAzureResourceModule<T extends IAzureBaseResource>
extends SubscriptionScoped<AbstractAzureResourceModule<T>>
implements AzureService<T> {
    public AbstractAzureResourceModule(@NotNull Function<List<Subscription>, AbstractAzureResourceModule<T>> creator, @Nullable List<Subscription> subscriptions) {
        super(creator, subscriptions);
    }

    public AbstractAzureResourceModule(@NotNull Function<List<Subscription>, AbstractAzureResourceModule<T>> creator) {
        super(creator);
    }

    @Preload
    private static void preload() {
        ((Stream)Azure.getServices(AbstractAzureResourceModule.class).stream().parallel()).forEach(rec$ -> ((AbstractAzureResourceModule)rec$).list(new boolean[0]));
    }

    public List<T> list(boolean ... force) {
        return ((Stream)this.getSubscriptions().stream().parallel()).flatMap(subscription -> this.list(subscription.getId(), force).stream()).collect(Collectors.toList());
    }

    @Nonnull
    public T get(@Nonnull String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.get(resourceId.subscriptionId(), resourceId.resourceGroupName(), resourceId.name());
    }

    @Nonnull
    public T get(@Nonnull String resourceGroup, @Nonnull String name) {
        return this.get(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    public abstract List<T> list(@Nonnull String var1, boolean ... var2);

    @Nonnull
    public abstract T get(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3);

    protected static <R extends AzureConfigurable<R>, T extends Manager> T getResourceManager(String subscriptionId, Supplier<AzureConfigurable<R>> configurableSupplier, AuthenticationMethod<R, T> authenticationMethod) {
        IAccount account = Azure.az(IAzureAccount.class).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
        AzureProfile azureProfile = new AzureProfile(null, subscriptionId, account.getEnvironment());
        TokenCredential tokenCredential = account.getTokenCredential(subscriptionId);
        AzureConfigurable configurable = configurableSupplier.get().withPolicy(AbstractAzureResourceModule.getUserAgentPolicy(userAgent)).withLogLevel(logLevel);
        return authenticationMethod.apply(configurable, tokenCredential, azureProfile);
    }

    protected static HttpPipelinePolicy getUserAgentPolicy(String userAgent) {
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }

    @FunctionalInterface
    protected static interface AuthenticationMethod<R extends AzureConfigurable<R>, T extends Manager> {
        public T apply(R var1, TokenCredential var2, AzureProfile var3);
    }
}

