/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.common.view.IView;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ActionGroup {
    @Nullable
    private IView.Label view;
    private final List<Object> actions;

    public ActionGroup(@Nonnull List<Object> actions) {
        this.actions = actions;
    }

    public ActionGroup(Object ... actions) {
        this.actions = Arrays.asList(actions);
    }

    public ActionGroup(@Nonnull List<Object> actions, @Nullable IView.Label view) {
        this.view = view;
        this.actions = actions;
    }

    @Nullable
    public IView.Label view() {
        return this.view;
    }

    public List<Object> actions() {
        return this.actions;
    }

    public static class Proxy
    extends ActionGroup {
        @Nullable
        private final String id;
        @Nonnull
        private final ActionGroup group;

        public Proxy(@Nonnull ActionGroup group) {
            super(group.actions, group.view);
            this.id = null;
            this.group = group;
        }

        public Proxy(@Nonnull ActionGroup group, @Nonnull String id) {
            super(group.actions, group.view);
            this.id = id;
            this.group = group;
        }

        @Nullable
        public String id() {
            return this.id;
        }

        @Nonnull
        public ActionGroup group() {
            return this.group;
        }
    }
}

