/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.entity;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureModule;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public interface IAzureBaseResource<T extends IAzureBaseResource, P extends IAzureBaseResource> {
    public static final String REST_SEGMENT_JOB_MANAGEMENT_TENANTID = "/#@";
    public static final String REST_SEGMENT_JOB_MANAGEMENT_RESOURCE = "/resource";

    @Nullable
    default public P parent() {
        return null;
    }

    @Nullable
    default public IAzureModule<? extends T, ? extends P> module() {
        return null;
    }

    public IAzureBaseResource<T, P> refresh();

    public boolean exists();

    public String name();

    public String id();

    default public String status() {
        return null;
    }

    default public void refreshStatus() {
    }

    default public String subscriptionId() {
        return ResourceId.fromString((String)this.id()).subscriptionId();
    }

    default public String resourceGroup() {
        return ResourceId.fromString((String)this.id()).resourceGroupName();
    }

    default public Subscription subscription() {
        return Azure.az(IAzureAccount.class).account().getSubscription(this.subscriptionId());
    }

    default public String portalUrl() {
        IAccount account = Azure.az(IAzureAccount.class).account();
        Subscription subscription = account.getSubscription(this.subscriptionId());
        return account.portalUrl() + REST_SEGMENT_JOB_MANAGEMENT_TENANTID + subscription.getTenantId() + REST_SEGMENT_JOB_MANAGEMENT_RESOURCE + this.id();
    }

    public static interface Status {
        public static final String UNSTABLE = "UNSTABLE";
        public static final String PENDING = "PENDING";
        public static final String DRAFT = "DRAFT";
        public static final String STABLE = "STABLE";
        public static final String LOADING = "LOADING";
        public static final String ERROR = "ERROR";
        public static final String RUNNING = "RUNNING";
        public static final String STOPPED = "STOPPED";
        public static final String UNKNOWN = "UNKNOWN";
        public static final List<String> status = Arrays.asList("UNSTABLE", "PENDING", "DRAFT", "STABLE", "LOADING", "ERROR", "RUNNING", "STOPPED", "UNKNOWN");
    }
}

