/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.event;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.microsoft.azure.toolkit.lib.common.event.AzureEvent;
import com.microsoft.azure.toolkit.lib.common.event.AzureOperationEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NonNls;

public class AzureEventBus {
    @NonNls
    private static final Map<String, EventBus> buses = new ConcurrentHashMap<String, EventBus>();

    public static <T, E extends AzureEvent<T>> void on(@Nonnull String type, @Nonnull EventListener<T, E> listener) {
        AzureEventBus.getBus(type).register(listener);
    }

    public static <T, E extends AzureEvent<T>> void off(@Nonnull String type, @Nonnull EventListener<T, E> listener) {
        AzureEventBus.getBus(type).unregister(listener);
    }

    public static <T, E extends AzureEvent<T>> void on(@Nonnull String type, @Nonnull Consumer<T> listener) {
        AzureEventBus.getBus(type).register(new EventListener(e -> listener.accept(e.getPayload())));
    }

    public static <T, E extends AzureEvent<T>> void after(@Nonnull String operation, @Nonnull Consumer<T> listener) {
        AzureEventBus.getBus(operation).register(new EventListener(e -> {
            if (e instanceof AzureOperationEvent && ((AzureOperationEvent)e).getStage() == AzureOperationEvent.Stage.AFTER) {
                listener.accept(e.getPayload());
            }
        }));
    }

    public static <T, E extends AzureEvent<T>> void before(@Nonnull String operation, @Nonnull Consumer<T> listener) {
        AzureEventBus.getBus(operation).register(new EventListener(e -> {
            if (e instanceof AzureOperationEvent && ((AzureOperationEvent)e).getStage() == AzureOperationEvent.Stage.BEFORE) {
                listener.accept(e.getPayload());
            }
        }));
    }

    public static <T, E extends AzureEvent<T>> void error(@Nonnull String operation, @Nonnull Consumer<T> listener) {
        AzureEventBus.getBus(operation).register(new EventListener(e -> {
            if (e instanceof AzureOperationEvent && ((AzureOperationEvent)e).getStage() == AzureOperationEvent.Stage.ERROR) {
                listener.accept(e.getPayload());
            }
        }));
    }

    public static void emit(@Nonnull String type) {
        AzureEventBus.emit(type, new SimpleEvent(type, null));
    }

    public static void emit(@Nonnull String type, @Nullable Object source) {
        AzureEventBus.emit(type, new SimpleEvent(type, source));
    }

    public static <T> void emit(@Nonnull String type, @Nonnull AzureEvent<T> event) {
        AzureEventBus.getBus(type).post(event);
    }

    private static EventBus getBus(String eventType) {
        return buses.computeIfAbsent(eventType, EventBus::new);
    }

    private static class SimpleEvent<T>
    implements AzureEvent<T> {
        @Nonnull
        private final String type;
        @Nullable
        private final Object source;
        @Nullable
        private T payload;

        @Override
        @Nonnull
        public String getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getSource() {
            return this.source;
        }

        @Override
        @Nullable
        public T getPayload() {
            return this.payload;
        }

        public SimpleEvent(@Nonnull String type, @Nullable Object source) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.source = source;
        }

        public SimpleEvent(@Nonnull String type, @Nullable Object source, @Nullable T payload) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            this.source = source;
            this.payload = payload;
        }
    }

    public static class EventListener<T, E extends AzureEvent<T>> {
        @Nonnull
        private final Consumer<E> listener;

        @Subscribe
        public void onEvent(@Nonnull E event) {
            this.listener.accept(event);
        }

        public EventListener(@Nonnull Consumer<E> listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.listener = listener;
        }
    }
}

