/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.DataStore;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskContext;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAzureOperation
extends DataStore {
    public static final String UNKNOWN_NAME = "<unknown>.<unknown>";

    @Nonnull
    default public String getId() {
        return Utils.getId(this);
    }

    @Nonnull
    default public String getName() {
        return Optional.ofNullable(this.getTitle()).map(AzureString::getName).orElse(UNKNOWN_NAME);
    }

    @Nonnull
    public String getType();

    @Nullable
    public AzureString getTitle();

    public void setParent(IAzureOperation var1);

    @Nullable
    public IAzureOperation getParent();

    default public IAzureOperation getEffectiveParent() {
        IAzureOperation parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.getName().equals(UNKNOWN_NAME)) {
            return parent;
        }
        return parent.getEffectiveParent();
    }

    @Nullable
    default public IAzureOperation getActionParent() {
        if (this.getType().equals(AzureOperation.Type.ACTION.name())) {
            return this;
        }
        return Optional.ofNullable(this.getParent()).map(IAzureOperation::getActionParent).orElse(null);
    }

    @Nullable
    public static IAzureOperation current() {
        return AzureTaskContext.current().currentOperation();
    }

    public static interface IContext {
    }
}

