/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.task;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureTask<T>
implements IAzureOperation {
    @Nonnull
    private final Modality modality;
    @Nullable
    private final Supplier<T> supplier;
    @Nullable
    private final Object project;
    private final boolean cancellable;
    @Nullable
    private final AzureString title;
    private IAzureOperation parent;
    private boolean backgroundable = true;
    @Nullable
    private Boolean backgrounded = null;
    @Nonnull
    private String type = "ASYNC";
    private Monitor monitor;

    public AzureTask() {
        this((Supplier)null);
    }

    public AzureTask(@Nonnull Runnable runnable) {
        this(runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull String title, @Nonnull Runnable runnable) {
        this(title, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Runnable runnable) {
        this(title, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Supplier<T> supplier) {
        this(supplier, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull String title, @Nonnull Supplier<T> supplier) {
        this(null, title, false, supplier, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Supplier<T> supplier) {
        this(null, title, false, supplier, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(null, (String)null, false, runnable, modality);
    }

    public AzureTask(@Nonnull String title, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(null, title, false, runnable, modality);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(null, title, false, runnable, modality);
    }

    public AzureTask(@Nullable Supplier<T> supplier, @Nonnull Modality modality) {
        this(null, (String)null, false, supplier, modality);
    }

    public AzureTask(@Nonnull String title, @Nonnull Supplier<T> supplier, @Nonnull Modality modality) {
        this(null, title, false, supplier, modality);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Supplier<T> supplier, @Nonnull Modality modality) {
        this(null, title, false, supplier, modality);
    }

    public AzureTask(@Nullable Object project, @Nonnull String title, boolean cancellable, @Nonnull Runnable runnable) {
        this(project, title, cancellable, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nonnull AzureString title, boolean cancellable, @Nonnull Runnable runnable) {
        this(project, title, cancellable, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nonnull String title, boolean cancellable, @Nonnull Supplier<T> supplier) {
        this(project, title, cancellable, supplier, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nonnull AzureString title, boolean cancellable, @Nonnull Supplier<T> supplier) {
        this(project, title, cancellable, supplier, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nullable String title, boolean cancellable, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(project, (AzureString)Optional.ofNullable(title).map(AzureString::fromString).orElse(null), cancellable, runnable, modality);
    }

    public AzureTask(@Nullable Object project, @Nullable AzureString title, boolean cancellable, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(project, title, cancellable, () -> {
            runnable.run();
            return null;
        }, modality);
    }

    public AzureTask(@Nullable Object project, @Nullable String title, boolean cancellable, @Nullable Supplier<T> supplier, @Nonnull Modality modality) {
        this(project, (AzureString)Optional.ofNullable(title).map(AzureString::fromString).orElse(null), cancellable, supplier, modality);
    }

    public AzureTask(@Nullable Object project, @Nullable AzureString title, boolean cancellable, @Nullable Supplier<T> supplier, @Nonnull Modality modality) {
        this.project = project;
        this.title = title;
        this.cancellable = cancellable;
        this.monitor = new DefaultMonitor();
        this.supplier = supplier;
        this.modality = modality;
    }

    @Override
    @Nonnull
    public String getId() {
        return "&" + IAzureOperation.super.getId();
    }

    public String toString() {
        return String.format("{name:'%s'}", this.getName());
    }

    @Nonnull
    public Supplier<T> getSupplier() {
        return Optional.ofNullable(this.supplier).orElse(this::execute);
    }

    public T execute() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Modality getModality() {
        return this.modality;
    }

    @Nullable
    public Object getProject() {
        return this.project;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    @Nullable
    public AzureString getTitle() {
        return this.title;
    }

    @Override
    public IAzureOperation getParent() {
        return this.parent;
    }

    public boolean isBackgroundable() {
        return this.backgroundable;
    }

    @Nullable
    public Boolean getBackgrounded() {
        return this.backgrounded;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void setParent(IAzureOperation parent) {
        this.parent = parent;
    }

    public void setBackgroundable(boolean backgroundable) {
        this.backgroundable = backgroundable;
    }

    public void setBackgrounded(@Nullable Boolean backgrounded) {
        this.backgrounded = backgrounded;
    }

    public void setType(@Nonnull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public static class DefaultMonitor
    implements Monitor {
        private boolean cancelled = false;

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    public static interface Monitor {
        public void cancel();

        public boolean isCancelled();
    }

    public static enum Modality {
        DEFAULT,
        ANY,
        NONE;

    }
}

