/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.microsoft.azure.toolkit.lib.common.cache.CacheEvict;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureResource;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureResourceEntity;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.event.AzureOperationEvent;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.ExpressionUtils;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractAzureResource<T extends IAzureResource<E>, E extends RemoteAwareResourceEntity<R>, R>
implements IAzureResource<E>,
AzureOperationEvent.Source<T> {
    private boolean refreshed;
    @Nonnull
    protected final E entity;
    private String status = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected AbstractAzureResource(@Nonnull E entity) {
        this.entity = entity;
    }

    @Override
    public final boolean exists() {
        if (Objects.isNull(this.remote()) && !this.refreshed) {
            this.refresh();
        }
        return Objects.nonNull(this.remote());
    }

    @Override
    @Nonnull
    @CacheEvict(cacheName="resource/{}/children", key="${this.id()}")
    @AzureOperation(name="resource.refresh.resource", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public synchronized void refresh() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        AbstractAzureResource.refresh_aroundBody1$advice(this, joinPoint, CacheManager.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    protected T refresh(@Nullable R remote) {
        ((RemoteAwareResourceEntity)this.entity).setRemote(remote);
        this.refreshed = true;
        this.refreshStatus();
        return (T)this;
    }

    @Override
    @Nonnull
    public final E entity() {
        return this.entity;
    }

    @Nullable
    public final R remote() {
        return ((RemoteAwareResourceEntity)this.entity).getRemote();
    }

    @Override
    public final String status() {
        if (Objects.nonNull(this.status)) {
            return this.status;
        }
        this.refreshStatus();
        return "Loading";
    }

    @Override
    public final void refreshStatus() {
        AzureTaskManager.getInstance().runOnPooledThread(() -> this.status(this.loadStatus()));
    }

    protected final void status(@Nonnull String status) {
        String oldStatus = this.status;
        this.status = status;
        if (!StringUtils.equalsIgnoreCase((CharSequence)oldStatus, (CharSequence)this.status)) {
            AzureEventBus.emit("common|resource.status_changed", this);
        }
    }

    @Nullable
    protected abstract R loadRemote();

    protected String loadStatus() {
        return "Running";
    }

    static {
        AbstractAzureResource.ajc$preClinit();
    }

    private static final /* synthetic */ void refresh_aroundBody0(AbstractAzureResource ajc$this, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ajc$this.status("Loading");
            ajc$this.refresh(ajc$this.loadRemote());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static final /* synthetic */ Object refresh_aroundBody1$advice(AbstractAzureResource ajc$this, JoinPoint thisJoinPoint, CacheManager ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean toEvictCache;
        MethodSignature signature = (MethodSignature)point.getSignature();
        MethodInvocation invocation = MethodInvocation.from((JoinPoint)point);
        CacheEvict annotation = signature.getMethod().getAnnotation(CacheEvict.class);
        String cacheName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.cacheName(), annotation.value()});
        String name = ExpressionUtils.render(cacheName, invocation);
        String key = ExpressionUtils.render(annotation.key(), invocation);
        String condition = annotation.condition();
        boolean bl = toEvictCache = StringUtils.isBlank((CharSequence)condition) || ExpressionUtils.evaluate(condition, invocation, true);
        if (toEvictCache) {
            CacheManager.ajc$inlineAccessFieldGet$com_microsoft_azure_toolkit_lib_common_cache_CacheManager$com_microsoft_azure_toolkit_lib_common_cache_CacheManager$log().fine(String.format("evict cache[%s.%s] on method[%s]", name, key, signature.getName()));
            CacheManager.evictCache(name, key);
        }
        ProceedingJoinPoint proceedingJoinPoint = point;
        AbstractAzureResource.refresh_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint);
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzureResource.java", AbstractAzureResource.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "refresh", "com.microsoft.azure.toolkit.lib.common.entity.AbstractAzureResource", "", "", "", "void"), 47);
    }

    public static abstract class RemoteAwareResourceEntity<R>
    implements IAzureResourceEntity {
        @Nullable
        @JsonIgnore
        protected transient R remote;

        @Nullable
        public R getRemote() {
            return this.remote;
        }

        @JsonIgnore
        public void setRemote(@Nullable R remote) {
            this.remote = remote;
        }
    }
}

