/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.entity;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceBase;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAzureBaseResource<T extends IAzureBaseResource, P extends IAzureBaseResource>
extends AzResourceBase {
    public static final String REST_SEGMENT_JOB_MANAGEMENT_TENANTID = "/#@";
    public static final String REST_SEGMENT_JOB_MANAGEMENT_RESOURCE = "/resource";

    public void refresh();

    @Override
    public boolean exists();

    @Override
    @Nonnull
    default public String getName() {
        return this.name();
    }

    @Override
    @Nonnull
    default public String getId() {
        return this.id();
    }

    @Override
    @Nonnull
    default public String getSubscriptionId() {
        return this.subscriptionId();
    }

    @Override
    default public String getResourceGroupName() {
        return this.resourceGroup();
    }

    @Override
    default public String getStatus() {
        return this.status();
    }

    @Override
    default public Subscription getSubscription() {
        return this.subscription();
    }

    @Override
    default public String getPortalUrl() {
        return this.portalUrl();
    }

    @Nullable
    @Deprecated
    default public P parent() {
        return null;
    }

    @Nullable
    @Deprecated
    default public IAzureModule<? extends T, ? extends P> module() {
        return null;
    }

    @Deprecated
    public String name();

    @Deprecated
    public String id();

    @Deprecated
    default public String status() {
        return null;
    }

    @Deprecated
    default public void refreshStatus() {
    }

    @Deprecated
    default public String subscriptionId() {
        return ResourceId.fromString((String)this.id()).subscriptionId();
    }

    @Deprecated
    default public String resourceGroup() {
        return ResourceId.fromString((String)this.id()).resourceGroupName();
    }

    @Deprecated
    default public Subscription subscription() {
        return Azure.az(IAzureAccount.class).account().getSubscription(this.subscriptionId());
    }

    default public String portalUrl() {
        IAccount account = Azure.az(IAzureAccount.class).account();
        Subscription subscription = account.getSubscription(this.subscriptionId());
        return account.portalUrl() + REST_SEGMENT_JOB_MANAGEMENT_TENANTID + subscription.getTenantId() + REST_SEGMENT_JOB_MANAGEMENT_RESOURCE + this.id();
    }

    public static interface Status {
        public static final String UNSTABLE = "UNSTABLE";
        public static final String PENDING = "Pending";
        public static final String CREATING = "Creating";
        public static final String DELETING = "Deleting";
        public static final String LOADING = "Loading";
        public static final String UPDATING = "Updating";
        public static final String SCALING = "Scaling";
        public static final String STARTING = "Starting";
        public static final String RESTARTING = "Restarting";
        public static final String STOPPING = "Stopping";
        public static final String DRAFT = "Draft";
        public static final String NULL = "NULL";
        public static final String STABLE = "STABLE";
        public static final String DELETED = "Deleted";
        public static final String ERROR = "Error";
        public static final String DISCONNECTED = "Disconnected";
        public static final String INACTIVE = "Inactive";
        public static final String RUNNING = "Running";
        public static final String STOPPED = "Stopped";
        public static final String UNKNOWN = "Unknown";
        public static final List<String> status = Arrays.asList("UNSTABLE", "Pending", "Draft", "STABLE", "Loading", "Error", "Running", "Stopped", "Unknown");
    }
}

