/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.bundle.CustomDecoratable;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAzureMessage {
    @Nonnull
    public AzureString getMessage();

    @Nonnull
    default public String getContent() {
        return this.getMessage().getString();
    }

    @Nonnull
    public Type getType();

    @Nullable
    public String getTitle();

    @Nullable
    public Object getPayload();

    @Nullable
    public Action<?>[] getActions();

    default public boolean show() {
        return AzureMessager.getMessager().show(this);
    }

    default public boolean show(IAzureMessager messager) {
        return messager.show(this);
    }

    @Nullable
    default public String decorateValue(@Nonnull Object p, @Nullable Supplier<String> dft) {
        String result = null;
        if (p instanceof CustomDecoratable) {
            result = ((CustomDecoratable)p).decorate(this);
        }
        return Objects.isNull(result) && Objects.nonNull(dft) ? dft.get() : result;
    }

    @Nullable
    default public String decorateText(@Nonnull AzureString text, @Nullable Supplier<String> dft) {
        String result = null;
        if (text instanceof CustomDecoratable) {
            result = ((CustomDecoratable)((Object)text)).decorate(this);
        }
        if (Objects.isNull(result)) {
            Object[] params = Arrays.stream(text.getParams()).map(p -> this.decorateValue(p, p::toString)).toArray();
            result = text.getString(params);
        }
        return Objects.isNull(result) && Objects.nonNull(dft) ? dft.get() : result;
    }

    public static interface ValueDecorator {
        public String decorateValue(@Nonnull Object var1, @Nullable IAzureMessage var2);
    }

    public static enum Type {
        INFO,
        WARNING,
        SUCCESS,
        ERROR,
        ALERT,
        CONFIRM;

    }
}

