/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public interface AzResourceBase {
    public boolean exists();

    @Nonnull
    public String getName();

    @Nonnull
    public String getId();

    @Nonnull
    public String getSubscriptionId();

    public String getResourceGroupName();

    public String getStatus();

    public Subscription getSubscription();

    public String getPortalUrl();

    default public FormalStatus getFormalStatus() {
        return StringUtils.isBlank((CharSequence)this.getStatus()) ? FormalStatus.UNKNOWN : FormalStatus.dummyFormalize(this.getStatus());
    }

    public static enum FormalStatus {
        RUNNING,
        STOPPED,
        FAILED,
        UNKNOWN,
        WRITING,
        READING;

        private static final HashSet<String> runningStatus;
        private static final HashSet<String> stoppedStatus;
        private static final HashSet<String> failedStatus;
        private static final HashSet<String> writingStatus;
        private static final HashSet<String> readingStatus;

        public static FormalStatus dummyFormalize(String status) {
            if (runningStatus.contains(status = status.toLowerCase())) {
                return RUNNING;
            }
            if (stoppedStatus.contains(status)) {
                return STOPPED;
            }
            if (failedStatus.contains(status)) {
                return FAILED;
            }
            if (writingStatus.contains(status)) {
                return WRITING;
            }
            if (readingStatus.contains(status)) {
                return READING;
            }
            return UNKNOWN;
        }

        public boolean isRunning() {
            return this == RUNNING;
        }

        public boolean isStopped() {
            return this == STOPPED;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean isWriting() {
            return this == WRITING;
        }

        public boolean isReading() {
            return this == READING;
        }

        public boolean isWaiting() {
            return this == WRITING || this == READING;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        static {
            runningStatus = Sets.newHashSet((Object[])new String[]{"running", "success", "succeeded", "ready", "ok"});
            stoppedStatus = Sets.newHashSet((Object[])new String[]{"stopped"});
            failedStatus = Sets.newHashSet((Object[])new String[]{"failed", "error"});
            writingStatus = Sets.newHashSet((Object[])new String[]{"writing", "pending", "processing", "creating", "updating", "deleting", "starting", "stopping", "restarting", "scaling"});
            readingStatus = Sets.newHashSet((Object[])new String[]{"reading", "loading", "refreshing"});
        }
    }
}

