/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;

public class Azure {
    private final AzureConfiguration configuration = new AzureConfiguration();
    private static final Azure defaultInstance = new Azure();

    private Azure() {
    }

    public static synchronized <T extends AzService> T az(Class<T> clazz) {
        T service = Azure.getService(clazz);
        if (service == null) {
            Holder.loader.reload();
            Holder.azLoader.reload();
            service = Azure.getService(clazz);
        }
        if (service != null) {
            return service;
        }
        throw new AzureToolkitRuntimeException(String.format("Azure service(%s) not supported", clazz.getSimpleName()));
    }

    @Nullable
    private static <T extends AzService> T getService(Class<T> clazz) {
        for (AzService service : Holder.azLoader) {
            if (!clazz.isInstance(service)) continue;
            return (T)((AzService)clazz.cast(service));
        }
        for (AzService service : Holder.loader) {
            if (!clazz.isInstance(service)) continue;
            return (T)((AzService)clazz.cast(service));
        }
        return null;
    }

    @Nonnull
    public static <T extends AzService> List<T> getServices(Class<T> clazz) {
        ArrayList<AzService> result = new ArrayList<AzService>();
        for (AzService service : Holder.azLoader) {
            if (!clazz.isInstance(service)) continue;
            result.add((AzService)clazz.cast(service));
        }
        for (AzService service : Holder.loader) {
            if (!clazz.isInstance(service)) continue;
            result.add((AzService)clazz.cast(service));
        }
        return result;
    }

    public static Azure az() {
        return defaultInstance;
    }

    public AzureConfiguration config() {
        return this.configuration;
    }

    private static class Holder {
        private static final ServiceLoader<AzService> azLoader = ServiceLoader.load(AzService.class, Azure.class.getClassLoader());
        private static final ServiceLoader<AzureService> loader = ServiceLoader.load(AzureService.class, Azure.class.getClassLoader());

        private Holder() {
        }
    }
}

