/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.Preload;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractAzService<T extends AbstractAzResourceManager<T, R>, R>
extends AbstractAzResourceModule<T, AzResource.None, R>
implements AzService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AbstractAzService(@Nonnull String name) {
        super(name, AzResource.NONE);
        AzureEventBus.on("account.logout.account", e -> this.clear());
        AzureEventBus.on("account.subscription_changed.account", e -> this.refresh());
    }

    @Override
    public String getFullResourceType() {
        return this.getName();
    }

    @Preload
    @AzureOperation(name="resource.preload", type=AzureOperation.Type.ACTION)
    private static void preload() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureTelemetry.getActionContext().setProperty("preloading", String.valueOf(true));
            List<AbstractAzService> services = Azure.getServices(AbstractAzService.class);
            ((Stream)services.stream().parallel()).flatMap(s -> s.list().stream()).flatMap(m -> ((AbstractAzResourceManager)m).getSubModules().stream()).forEach(m -> ((AzResourceModule)m).list());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public T forSubscription(@Nonnull String subscriptionId) {
        return (T)((AbstractAzResourceManager)this.get(subscriptionId, null));
    }

    @Override
    public void refresh() {
        super.refresh();
        this.list().forEach(AbstractAzResource::refresh);
    }

    @Override
    @Nonnull
    protected Stream<R> loadResourcesFromAzure() {
        return ((Stream)Azure.az(IAzureAccount.class).account().getSelectedSubscriptions().stream().parallel()).map(Subscription::getId).map(i -> this.loadResourceFromAzure((String)i, null));
    }

    @Override
    @Nonnull
    public String toResourceId(@Nonnull String resourceName, String resourceGroup) {
        String rg = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, "${rg}"});
        return String.format("/subscriptions/%s/resourceGroups/%s/providers/%s", resourceName, rg, this.getName());
    }

    static {
        AbstractAzService.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzService.java", AbstractAzService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "preload", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzService", "", "", "", "void"), 39);
    }
}

