/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.entity.IAzureBaseResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceBase;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AzResource<T extends AzResource<T, P, R>, P extends AzResource<P, ?, ?>, R>
extends AzResourceBase,
IAzureBaseResource<T, P> {
    public static final None NONE = new None();
    public static final String RESOURCE_GROUP_PLACEHOLDER = "${rg}";

    @Override
    public boolean exists();

    @Override
    public void refresh();

    @Nonnull
    public AzResourceModule<T, P, R> getModule();

    @Override
    @Nonnull
    public String getName();

    default public String getFullResourceType() {
        return this.getModule().getFullResourceType();
    }

    default public String getResourceTypeName() {
        return this.getModule().getResourceTypeName();
    }

    @Override
    @Nonnull
    default public String getId() {
        return String.format("%s/%s", this.getModule().getId(), this.getName());
    }

    @Nonnull
    default public P getParent() {
        return this.getModule().getParent();
    }

    @Override
    @Nonnull
    default public String getSubscriptionId() {
        return this.getModule().getSubscriptionId();
    }

    @Override
    @Nonnull
    default public String getResourceGroupName() {
        return ResourceId.fromString((String)this.getId()).resourceGroupName();
    }

    public Draft<T, R> update();

    public void delete();

    @Nullable
    public R getRemote();

    @Override
    public String getStatus();

    @Override
    default public Subscription getSubscription() {
        return Azure.az(IAzureAccount.class).account().getSubscription(this.getSubscriptionId());
    }

    @Override
    default public String getPortalUrl() {
        IAccount account = Azure.az(IAzureAccount.class).account();
        Subscription subscription = account.getSubscription(this.getSubscriptionId());
        return String.format("%s/#@%s/resource%s", account.portalUrl(), subscription.getTenantId(), this.getId());
    }

    @Override
    @Deprecated
    default public String name() {
        return this.getName();
    }

    @Override
    @Deprecated
    default public String id() {
        return this.getId();
    }

    @Override
    @Deprecated
    default public String status() {
        return this.getStatus();
    }

    @Override
    @Deprecated
    default public void refreshStatus() {
    }

    @Override
    @Deprecated
    default public String subscriptionId() {
        return this.getSubscriptionId();
    }

    @Override
    @Deprecated
    default public String resourceGroup() {
        return ResourceId.fromString((String)this.id()).resourceGroupName();
    }

    @Override
    @Deprecated
    default public Subscription subscription() {
        return this.getSubscription();
    }

    public static interface Draft<T extends AzResource<T, ?, R>, R> {
        public String getName();

        public String getResourceGroupName();

        public AzResourceModule<T, ?, R> getModule();

        default public T commit() {
            boolean existing = this.getModule().exists(this.getName(), this.getResourceGroupName());
            T result = existing ? this.getModule().update(this) : this.getModule().create(this);
            this.reset();
            return result;
        }

        public void reset();

        default public T createIfNotExist() {
            T origin = this.getModule().get(this.getName(), this.getResourceGroupName());
            if (Objects.isNull(origin) || !origin.exists()) {
                return this.getModule().create(this);
            }
            return origin;
        }

        default public T updateIfExist() {
            T origin = this.getModule().get(this.getName(), this.getResourceGroupName());
            if (Objects.nonNull(origin) && origin.exists()) {
                return this.getModule().update(this);
            }
            return origin;
        }

        public R createResourceInAzure();

        default public T asResource() {
            return (T)((AzResource)((Object)this));
        }

        public R updateResourceInAzure(@Nonnull R var1);

        public boolean isModified();

        @Nullable
        public T getOrigin();
    }

    public static final class None
    extends AbstractAzResource<None, None, Void> {
        private static final String NONE = "$NONE$";
        private final String id = "$NONE$";
        private final String name = "$NONE$";
        private final String status = "$NONE$";
        private final String subscriptionId = "$NONE$";

        private None() {
            super(NONE, AzResource.RESOURCE_GROUP_PLACEHOLDER, AzResourceModule.NONE);
        }

        @Override
        public List<AzResourceModule<?, None, ?>> getSubModules() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public AbstractAzResourceModule<None, None, Void> getModule() {
            return AzResourceModule.NONE;
        }

        @Override
        public String getFullResourceType() {
            return NONE;
        }

        @Override
        public String getResourceTypeName() {
            return NONE;
        }

        @Override
        @Nonnull
        public String loadStatus(@Nonnull Void remote) {
            return "Unknown";
        }

        @Override
        public boolean equals(Object o) {
            return NONE == o;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public String getId() {
            Objects.requireNonNull(this);
            return NONE;
        }

        @Override
        public String getName() {
            Objects.requireNonNull(this);
            return NONE;
        }

        @Override
        public String getStatus() {
            Objects.requireNonNull(this);
            return NONE;
        }

        @Override
        public String getSubscriptionId() {
            Objects.requireNonNull(this);
            return NONE;
        }
    }
}

