/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AzResourceModule<T extends AzResource<T, P, R>, P extends AzResource<P, ?, ?>, R> {
    public static final None NONE = new None();

    @Nonnull
    public List<T> list();

    @Nullable
    public T get(@Nonnull String var1, String var2);

    public boolean exists(@Nonnull String var1, String var2);

    public void delete(@Nonnull String var1, String var2);

    public T create(@Nonnull AzResource.Draft<T, R> var1);

    public T update(@Nonnull AzResource.Draft<T, R> var1);

    public void refresh();

    @Nonnull
    public String getName();

    default public String getFullResourceType() {
        return this.getParent().getFullResourceType() + "/" + this.getName();
    }

    public String getResourceTypeName();

    @Nonnull
    public P getParent();

    @Nonnull
    default public String getSubscriptionId() {
        return this.getParent().getSubscriptionId();
    }

    @Nonnull
    default public String getId() {
        return String.format("%s/%s", this.getParent().getId(), this.getName());
    }

    public static final class None
    extends AbstractAzResourceModule<AzResource.None, AzResource.None, Void> {
        public None() {
            super("NONE", AzResource.NONE);
        }

        @Override
        protected AzResource.None newResource(@Nonnull Void unused) {
            return AzResource.NONE;
        }

        @Override
        public String getResourceTypeName() {
            return "NONE";
        }

        @Override
        @Nonnull
        public AzResource.None getParent() {
            return AzResource.NONE;
        }

        @Override
        protected Object getClient() {
            throw new AzureToolkitRuntimeException("not supported");
        }

        @Override
        public boolean equals(Object o) {
            return NONE == o;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

