/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Subscription {
    @Nonnull
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String tenantId;
    @JsonProperty
    private boolean selected;

    protected Subscription(SubscriptionBuilder<?, ?> b) {
        this.id = ((SubscriptionBuilder)b).id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.name = ((SubscriptionBuilder)b).name;
        this.tenantId = ((SubscriptionBuilder)b).tenantId;
        this.selected = ((SubscriptionBuilder)b).selected;
    }

    public static SubscriptionBuilder<?, ?> builder() {
        return new SubscriptionBuilderImpl();
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @JsonProperty
    public void setId(@Nonnull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Subscription() {
    }

    public Subscription(@Nonnull String id, String name, String tenantId, boolean selected) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.tenantId = tenantId;
        this.selected = selected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelected() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    private static final class SubscriptionBuilderImpl
    extends SubscriptionBuilder<Subscription, SubscriptionBuilderImpl> {
        private SubscriptionBuilderImpl() {
        }

        @Override
        protected SubscriptionBuilderImpl self() {
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }
    }

    public static abstract class SubscriptionBuilder<C extends Subscription, B extends SubscriptionBuilder<C, B>> {
        private String id;
        private String name;
        private String tenantId;
        private boolean selected;

        protected abstract B self();

        public abstract C build();

        @JsonProperty
        public B id(@Nonnull String id) {
            this.id = id;
            return this.self();
        }

        @JsonProperty
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @JsonProperty
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @JsonProperty
        public B selected(boolean selected) {
            this.selected = selected;
            return this.self();
        }

        public String toString() {
            return "Subscription.SubscriptionBuilder(id=" + this.id + ", name=" + this.name + ", tenantId=" + this.tenantId + ", selected=" + this.selected + ")";
        }
    }
}

