/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.task;

import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationContext;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.Single;
import rx.functions.Func2;
import rx.plugins.RxJavaHooks;

public class AzureRxTaskManager {
    private static boolean registered = false;

    public static synchronized void register() {
        if (registered) {
            throw new IllegalStateException("rx task manager has already been registered.");
        }
        registered = true;
        Func2 oldObservableStartHooks = RxJavaHooks.getOnObservableStart();
        Func2 oldCompletableStartHooks = RxJavaHooks.getOnCompletableStart();
        Func2 oldSingleStartHooks = RxJavaHooks.getOnSingleStart();
        RxJavaHooks.setOnObservableStart((observable, onStart) -> {
            AzureOperationContext context = AzureOperationContext.current().derive();
            Observable.OnSubscribe withClosure = subscriber -> context.run(() -> onStart.call(subscriber));
            if (Objects.isNull(oldObservableStartHooks)) {
                return withClosure;
            }
            return (Observable.OnSubscribe)oldObservableStartHooks.call(observable, (Object)withClosure);
        });
        RxJavaHooks.setOnCompletableStart((completable, onStart) -> {
            AzureOperationContext context = AzureOperationContext.current().derive();
            Completable.OnSubscribe withClosure = subscriber -> context.run(() -> onStart.call(subscriber));
            if (Objects.isNull(oldCompletableStartHooks)) {
                return withClosure;
            }
            return (Completable.OnSubscribe)oldCompletableStartHooks.call(completable, (Object)withClosure);
        });
        RxJavaHooks.setOnSingleStart((single, onStart) -> {
            AzureOperationContext context = AzureOperationContext.current().derive();
            Single.OnSubscribe withClosure = subscriber -> context.run(() -> onStart.call(subscriber));
            if (Objects.isNull(oldSingleStartHooks)) {
                return withClosure;
            }
            return (Single.OnSubscribe)oldSingleStartHooks.call(single, (Object)withClosure);
        });
    }
}

