/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.view.IView;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ActionView
implements IView.Label {
    @Nonnull
    private final String label;
    private final String iconPath;
    @Nullable
    private AzureString title;
    private final boolean enabled;

    @Override
    public String getDescription() {
        return Optional.ofNullable(this.title).map(AzureString::toString).orElse(null);
    }

    @Override
    public void dispose() {
    }

    @Override
    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Nullable
    public AzureString getTitle() {
        return this.title;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ActionView(@Nonnull String label, String iconPath, boolean enabled) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        this.iconPath = iconPath;
        this.enabled = enabled;
    }

    public ActionView(@Nonnull String label, String iconPath, @Nullable AzureString title, boolean enabled) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        this.iconPath = iconPath;
        this.title = title;
        this.enabled = enabled;
    }

    public static class Builder {
        @Nonnull
        protected final Function<Object, String> label;
        @Nullable
        protected Function<Object, String> iconPath;
        @Nullable
        protected Function<Object, AzureString> title;
        @Nullable
        protected Function<Object, Boolean> enabled = s -> true;

        public Builder(String label) {
            this((Object s) -> label);
        }

        public Builder(String label, String iconPath) {
            this((Object s) -> label);
            this.iconPath = s -> iconPath;
        }

        public ActionView toActionView(Object s) {
            try {
                Boolean e = Optional.ofNullable(this.enabled).map(p -> (Boolean)p.apply(s)).orElse(true);
                String i = Optional.ofNullable(this.iconPath).map(p -> (String)p.apply(s)).orElse(null);
                AzureString t = Optional.ofNullable(this.title).map(p -> (AzureString)p.apply(s)).orElse(null);
                return new ActionView(this.label.apply(s), i, t, e);
            }
            catch (Exception e) {
                return new ActionView("", "", false);
            }
        }

        public Builder(@Nonnull Function<Object, String> label) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
        }

        public Builder iconPath(@Nullable Function<Object, String> iconPath) {
            this.iconPath = iconPath;
            return this;
        }

        public Builder title(@Nullable Function<Object, AzureString> title) {
            this.title = title;
            return this;
        }

        public Builder enabled(@Nullable Function<Object, Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Function<Object, String> label() {
            return this.label;
        }

        @Nullable
        public Function<Object, String> iconPath() {
            return this.iconPath;
        }

        @Nullable
        public Function<Object, AzureString> title() {
            return this.title;
        }

        @Nullable
        public Function<Object, Boolean> enabled() {
            return this.enabled;
        }
    }
}

