/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.form;

import com.microsoft.azure.toolkit.lib.common.DataStore;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.form.AzureValidationInfo;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface AzureFormInput<T>
extends DataStore {
    public static final String MSG_REQUIRED = "This field is required.";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_DEFAULT_VALUE = "defaultValue";
    public static final String FIELD_VALIDATORS = "validators";
    public static final String FIELD_REQUIRED = "required";
    public static final String FIELD_VALIDATION_INFO = "validationInfo";
    public static final String FIELD_VALUE_LISTENERS = "valueListeners";
    public static final String FIELD_TRACKING = "tracking";
    public static final String FIELD_VALIDATING = "validating";

    default public T getValue() {
        return (T)this.get(FIELD_VALUE);
    }

    default public void setValue(T val) {
        this.set(FIELD_VALUE, val);
    }

    default public T getDefaultValue() {
        return (T)this.get(FIELD_DEFAULT_VALUE);
    }

    default public void setDefaultValue(T val) {
        this.set(FIELD_DEFAULT_VALUE, val);
    }

    default public void addValueChangedListener(Consumer<T> listener) {
        CopyOnWriteArrayList<Consumer<T>> valueChangedListeners = this.get(FIELD_VALUE_LISTENERS, new CopyOnWriteArrayList());
        if (!valueChangedListeners.contains(listener)) {
            valueChangedListeners.add(listener);
        }
    }

    default public void removeValueChangedListener(Consumer<T> listener) {
        CopyOnWriteArrayList valueChangedListeners = this.get(FIELD_VALUE_LISTENERS, new CopyOnWriteArrayList());
        valueChangedListeners.remove(listener);
    }

    default public List<Consumer<T>> getValueChangedListeners() {
        return new ArrayList<Consumer<T>>(this.get(FIELD_VALUE_LISTENERS, new CopyOnWriteArrayList()));
    }

    default public boolean fireValueChangedEvent(T val) {
        boolean changed;
        Object value = this.get(FIELD_VALUE);
        boolean bl = changed = !Objects.equals(val, value);
        if (changed) {
            this.set(FIELD_VALUE, val);
            this.getValueChangedListeners().forEach(l -> l.accept(val));
        } else {
            this.setValidationInfo(this.getValidationInfo());
        }
        return changed;
    }

    default public boolean fireValueChangedEvent() {
        DataStore.Field VALIDATING = DataStore.Field.of(FIELD_VALIDATING);
        MutableTriple validating = (MutableTriple)this.get(VALIDATING);
        T value = null;
        try {
            value = this.getValue();
        }
        catch (Exception e) {
            Optional.ofNullable(validating).ifPresent(v -> ((Disposable)v.getRight()).dispose());
            String msg = StringUtils.isBlank((CharSequence)e.getMessage()) ? "invalid value." : e.getMessage();
            AzureValidationInfo info = AzureValidationInfo.error(msg, this);
            this.setValidationInfo(info);
        }
        return this.fireValueChangedEvent(value);
    }

    default public String getLabel() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    @Deprecated
    default public AzureValidationInfo doValidate(T value) {
        return AzureValidationInfo.none(this);
    }

    default public AzureValidationInfo validateInternal(T v) {
        if (this.isRequired() && ObjectUtils.isEmpty(v)) {
            String message = StringUtils.isEmpty((CharSequence)this.getLabel()) ? MSG_REQUIRED : String.format("\"%s\" is required.", this.getLabel());
            return AzureValidationInfo.error(message, this);
        }
        AzureValidationInfo result = null;
        Collection<Validator> validators = this.getValidators();
        validators.add(() -> this.doValidate(v));
        for (Validator validator : validators) {
            AzureValidationInfo info;
            try {
                info = (AzureValidationInfo)ObjectUtils.firstNonNull((Object[])new AzureValidationInfo[]{validator.doValidate(), AzureValidationInfo.none(this)});
            }
            catch (Exception e) {
                info = AzureValidationInfo.error(e.getMessage(), this);
            }
            if (result == null || info.getType().ordinal() < result.getType().ordinal()) {
                result = info;
            }
            if (info.isValid()) continue;
            break;
        }
        return (AzureValidationInfo)ObjectUtils.firstNonNull((Object[])new AzureValidationInfo[]{result, AzureValidationInfo.none(this)});
    }

    @Nonnull
    default public AzureValidationInfo validateValue() {
        return (AzureValidationInfo)this.validateValueAsync().block();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Mono<AzureValidationInfo> validateValueAsync() {
        AzureFormInput azureFormInput = this;
        synchronized (azureFormInput) {
            T value;
            DataStore.Field VALIDATING = DataStore.Field.of(FIELD_VALIDATING);
            MutableTriple validating = (MutableTriple)this.get(VALIDATING);
            Runnable cancelValidating = () -> {
                Optional.ofNullable(validating).ifPresent(v -> ((Disposable)v.getRight()).dispose());
                this.set(VALIDATING, null);
            };
            if (!this.needValidation()) {
                cancelValidating.run();
                AzureValidationInfo info = AzureValidationInfo.none(this);
                this.setValidationInfo(info);
                return Mono.just((Object)info);
            }
            try {
                value = this.getValue();
            }
            catch (Exception e) {
                cancelValidating.run();
                String msg = StringUtils.isBlank((CharSequence)e.getMessage()) ? "invalid value." : e.getMessage();
                AzureValidationInfo info = AzureValidationInfo.error(msg, this);
                this.setValidationInfo(info);
                return Mono.just((Object)info);
            }
            if (Objects.nonNull(validating) && Objects.equals(validating.getLeft(), value)) {
                return (Mono)validating.getMiddle();
            }
            cancelValidating.run();
            return this.validateInternalAsync(value);
        }
    }

    @Nonnull
    default public Mono<AzureValidationInfo> validateInternalAsync(T value) {
        DataStore.Field VALIDATING = DataStore.Field.of(FIELD_VALIDATING);
        MutableTriple validating = MutableTriple.of(value, null, null);
        this.setValidationInfo(AzureValidationInfo.pending(this));
        AzureString title = AzureString.format("validating \"%s\"...", this.getLabel());
        Mono flux = Mono.just(Optional.ofNullable(value)).publishOn(Schedulers.fromExecutor(command -> AzureTaskManager.getInstance().runInBackground(new AzureTask<Void>(title, command)))).map(ov -> this.validateInternal(ov.orElse(null))).doFinally(s -> {
            if (Objects.equals(validating, this.get(VALIDATING))) {
                this.set(VALIDATING, null);
            }
        }).share();
        validating.setMiddle((Object)flux);
        validating.setRight((Object)flux.subscribe(info -> {
            if (Objects.equals(value, this.getValue())) {
                this.setValidationInfo((AzureValidationInfo)info);
            }
        }));
        this.set(VALIDATING, validating);
        return flux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void trackValidation() {
        AzureFormInput azureFormInput = this;
        synchronized (azureFormInput) {
            DataStore.Field TRACKING = DataStore.Field.of(FIELD_TRACKING);
            Consumer<Object> tracking = (Consumer<Object>)this.get(TRACKING);
            if (Objects.isNull(tracking)) {
                tracking = v -> this.validateValueAsync();
                this.addValueChangedListener(tracking);
                this.set(TRACKING, tracking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void setValidationInfo(@Nullable AzureValidationInfo info) {
        AzureFormInput azureFormInput = this;
        synchronized (azureFormInput) {
            this.set(FIELD_VALIDATION_INFO, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public AzureValidationInfo getValidationInfo() {
        AzureFormInput azureFormInput = this;
        synchronized (azureFormInput) {
            return (AzureValidationInfo)this.get(FIELD_VALIDATION_INFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public AzureValidationInfo getValidationInfo(boolean revalidateIfNone) {
        AzureFormInput azureFormInput = this;
        synchronized (azureFormInput) {
            AzureValidationInfo info = this.getValidationInfo();
            if (revalidateIfNone && Objects.isNull(info)) {
                this.validateValueAsync();
            }
            return this.getValidationInfo();
        }
    }

    @Nonnull
    default public Collection<Validator> getValidators() {
        return new ArrayList<Validator>(this.get(FIELD_VALIDATORS, new ArrayList()));
    }

    @Deprecated
    default public void setValidator(@Nonnull Validator validator) {
        if (Objects.isNull(validator)) {
            throw new AzureToolkitRuntimeException("'validator' can not be null.");
        }
        this.set(FIELD_VALIDATORS, Arrays.asList(validator));
    }

    default public void addValidator(@Nonnull Validator validator) {
        if (Objects.isNull(validator)) {
            throw new AzureToolkitRuntimeException("'validator' can not be null.");
        }
        Collection validators = this.get(FIELD_VALIDATORS, new ArrayList());
        validators.add(validator);
    }

    default public boolean isRequired() {
        return this.get(FIELD_REQUIRED, Boolean.valueOf(false));
    }

    default public void setRequired(boolean required) {
        this.set(FIELD_REQUIRED, Boolean.valueOf(required));
    }

    default public boolean needValidation() {
        return this.isRequired() || !this.getValidators().isEmpty();
    }

    @FunctionalInterface
    public static interface Validator {
        public AzureValidationInfo doValidate();
    }
}

