/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.event.AzureEventBus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.Debouncer;
import com.microsoft.azure.toolkit.lib.common.utils.TailingDebouncer;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.GenericResourceModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzResource<T extends AbstractAzResource<T, P, R>, P extends AbstractAzResource<P, ?, ?>, R>
implements AzResource<T, P, R> {
    private static final Logger log;
    @Nonnull
    private final String name;
    @Nonnull
    private final String resourceGroupName;
    @Nonnull
    private final AbstractAzResourceModule<T, P, R> module;
    @Nonnull
    final AtomicReference<R> remoteRef;
    @Nonnull
    final AtomicLong syncTimeRef;
    @Nonnull
    final AtomicReference<String> statusRef;
    @Nonnull
    private final Debouncer fireEvents = new TailingDebouncer(this::fireStatusChangedEvent, 300);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected AbstractAzResource(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, R> module) {
        this.name = name;
        this.resourceGroupName = resourceGroupName;
        this.module = module;
        this.remoteRef = new AtomicReference();
        this.syncTimeRef = new AtomicLong(-1L);
        this.statusRef = new AtomicReference<String>("Unknown");
    }

    protected AbstractAzResource(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, R> module) {
        this(name, ((AbstractAzResource)module.getParent()).getResourceGroupName(), module);
    }

    protected AbstractAzResource(@Nonnull T origin) {
        this.name = ((AbstractAzResource)origin).getName();
        this.resourceGroupName = ((AbstractAzResource)origin).getResourceGroupName();
        this.module = ((AbstractAzResource)origin).getModule();
        this.remoteRef = ((AbstractAzResource)origin).remoteRef;
        this.statusRef = ((AbstractAzResource)origin).statusRef;
        this.syncTimeRef = ((AbstractAzResource)origin).syncTimeRef;
    }

    @Override
    public boolean exists() {
        AbstractAzResource parent = (AbstractAzResource)this.getParent();
        if (StringUtils.equals((CharSequence)this.statusRef.get(), (CharSequence)"Deleted")) {
            return false;
        }
        if (parent == AzResource.NONE || this instanceof AbstractAzServiceSubscription || this instanceof ResourceGroup) {
            return this.remoteOptional().isPresent();
        }
        ResourceGroup rg = this.getResourceGroup();
        return Objects.nonNull(rg) && rg.exists() && parent.exists() && this.remoteOptional().isPresent();
    }

    @Override
    public void refresh() {
        log.debug("[{}:{}]:refresh()", (Object)this.module.getName(), (Object)this.getName());
        this.syncTimeRef.set(-1L);
        log.debug("[{}:{}]:refresh->subModules.refresh()", (Object)this.module.getName(), (Object)this.getName());
        this.getSubModules().forEach(AzResourceModule::refresh);
        AzureEventBus.emit("resource.refreshed.resource", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final R getRemote() {
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            while (this.syncTimeRef.get() == 0L) {
                try {
                    this.syncTimeRef.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.syncTimeRef.set(-1L);
                }
            }
            if (this.syncTimeRef.compareAndSet(-1L, 0L)) {
                log.debug("[{}:{}]:getRemote->reload()", (Object)this.module.getName(), (Object)this.getName());
                this.reloadRemote();
            }
            return this.remoteRef.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AzureOperation(name="resource.reload.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    private void reloadRemote() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}:{}]:reload()", (Object)this.module.getName(), (Object)this.getName());
            if (this.isDraftForCreating()) {
                AtomicLong atomicLong = this.syncTimeRef;
                synchronized (atomicLong) {
                    this.syncTimeRef.compareAndSet(0L, -1L);
                    this.syncTimeRef.notifyAll();
                }
            } else {
                Azure.az(IAzureAccount.class).account();
                R remote = this.remoteRef.get();
                this.doModify(() -> {
                    log.debug("[{}:{}]:reload->this.refreshRemote()", (Object)this.module.getName(), (Object)this.getName());
                    Object refreshed = Objects.nonNull(remote) ? this.refreshRemote(remote) : null;
                    log.debug("[{}:{}]:reload->this.loadRemote()", (Object)this.module.getName(), (Object)this.getName());
                    return Objects.nonNull(refreshed) ? refreshed : this.loadRemote();
                }, "Loading");
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    protected final R loadRemote() {
        log.debug("[{}:{}]:reloadRemote()", (Object)this.module.getName(), (Object)this.getName());
        try {
            return ((AbstractAzResourceModule)this.getModule()).loadResourceFromAzure(this.getName(), this.getResourceGroupName());
        }
        catch (Exception e) {
            Throwable cause;
            log.debug("[{}:{}]:reload->this.refreshRemote/loadResourceFromAzure=EXCEPTION", new Object[]{this.module.getName(), this.getName(), e});
            Throwable throwable = cause = e instanceof ManagementException ? e : ExceptionUtils.getRootCause((Throwable)e);
            if (cause instanceof ManagementException && 404 == ((ManagementException)cause).getResponse().getStatusCode()) {
                return null;
            }
            throw e;
        }
    }

    @Nullable
    protected R refreshRemote(@Nonnull R remote) {
        log.debug("[{}:{}]:refreshRemote()", (Object)this.module.getName(), (Object)this.getName());
        if (remote instanceof Refreshable) {
            log.debug("[{}:{}]:refreshRemote->remote.refresh()", (Object)this.module.getName(), (Object)this.getName());
            return (R)((Refreshable)remote).refresh();
        }
        log.debug("[{}:{}]:refreshRemote->reloadRemote()", (Object)this.module.getName(), (Object)this.getName());
        return this.loadRemote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemote(@Nullable R newRemote) {
        R oldRemote = this.remoteRef.get();
        AtomicLong atomicLong = this.syncTimeRef;
        synchronized (atomicLong) {
            log.debug("[{}:{}]:setRemote({})", new Object[]{this.module.getName(), this.getName(), newRemote});
            log.debug("[{}:{}]:setRemote->this.remoteRef.set({})", new Object[]{this.module.getName(), this.getName(), newRemote});
            this.remoteRef.set(newRemote);
            this.syncTimeRef.set(System.currentTimeMillis());
            this.syncTimeRef.notifyAll();
        }
        if (Objects.nonNull(newRemote)) {
            log.debug("[{}:{}]:setRemote->setStatus(LOADING)", (Object)this.module.getName(), (Object)this.getName());
            this.setStatus("Loading");
            log.debug("[{}:{}]:setRemote->this.reloadStatus", (Object)this.module.getName(), (Object)this.getName());
            AzureTaskManager.getInstance().runOnPooledThread(this::reloadStatus);
        } else {
            log.debug("[{}:{}]:setRemote->this.setStatus(DISCONNECTED)", (Object)this.module.getName(), (Object)this.getName());
            this.setStatus("Deleted");
            this.getSubModules().stream().flatMap(m -> m.listLocalResources().stream()).forEach(r -> r.setRemote(null));
        }
        if (oldRemote == null || newRemote == null) {
            this.getSubModules().forEach(AbstractAzResourceModule::clear);
        }
    }

    @Override
    @Nonnull
    public AzResource.Draft<T, R> update() {
        log.debug("[{}:{}]:update()", (Object)this.module.getName(), (Object)this.getName());
        log.debug("[{}:{}]:update->module.update(this)", (Object)this.module.getName(), (Object)this.getName());
        return ((AbstractAzResourceModule)this.getModule()).update((AbstractAzResource)this.cast(this));
    }

    @Override
    public void delete() {
        log.debug("[{}:{}]:delete()", (Object)this.module.getName(), (Object)this.getName());
        this.doModify(() -> {
            if (this.exists()) {
                this.deleteFromAzure();
            }
            return null;
        }, "Deleting");
        this.deleteFromLocal();
    }

    private void deleteFromAzure() {
        log.debug("[{}:{}]:delete->module.deleteResourceFromAzure({})", new Object[]{this.module.getName(), this.getName(), this.getId()});
        try {
            ((AbstractAzResourceModule)this.getModule()).deleteResourceFromAzure(this.getId());
        }
        catch (Exception e) {
            Throwable cause;
            Throwable throwable = cause = e instanceof ManagementException ? e : ExceptionUtils.getRootCause((Throwable)e);
            if (cause instanceof ManagementException && 404 != ((ManagementException)cause).getResponse().getStatusCode()) {
                log.debug("[{}]:delete()->deleteResourceFromAzure()=SC_NOT_FOUND", (Object)this.name, (Object)e);
            }
            this.getSubModules().stream().flatMap(m -> m.listLocalResources().stream()).forEach(r -> r.setStatus("Unknown"));
            throw e;
        }
    }

    public void deleteFromLocal() {
        log.debug("[{}:{}]:delete->this.setStatus(DELETED)", (Object)this.module.getName(), (Object)this.getName());
        this.setStatus("Deleted");
        log.debug("[{}:{}]:delete->module.deleteResourceFromLocal({})", new Object[]{this.module.getName(), this.getName(), this.getName()});
        ((AbstractAzResourceModule)this.getModule()).deleteResourceFromLocal(this.getId(), new boolean[0]);
        ResourceId id = ResourceId.fromString((String)this.getId());
        ResourceGroup resourceGroup = this.getResourceGroup();
        if (Objects.isNull(id.parent()) && Objects.nonNull(resourceGroup)) {
            GenericResourceModule genericResourceModule = resourceGroup.genericResources();
            genericResourceModule.deleteResourceFromLocal(this.getId(), new boolean[0]);
        }
        this.getSubModules().stream().flatMap(m -> m.listLocalResources().stream()).forEach(AbstractAzResource::deleteFromLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(@Nonnull String status) {
        AtomicReference<String> atomicReference = this.statusRef;
        synchronized (atomicReference) {
            log.debug("[{}:{}]:setStatus({})", new Object[]{this.module.getName(), this.getName(), status});
            String oldStatus = this.statusRef.get();
            if (!Objects.equals(oldStatus, status)) {
                this.statusRef.set(status);
                if (!StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"Loading")) {
                    this.statusRef.notifyAll();
                }
                this.fireEvents.debounce();
                if (StringUtils.equalsAny((CharSequence)status, (CharSequence[])new CharSequence[]{"Deleting", "Deleted"})) {
                    this.getSubModules().stream().flatMap(m -> m.listLocalResources().stream()).forEach(r -> r.setStatus(status));
                }
            }
        }
    }

    @AzureOperation(name="resource.reload_status.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    private void reloadStatus() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            log.debug("[{}:{}]:reloadStatus()", (Object)this.module.getName(), (Object)this.getName());
            try {
                log.debug("[{}:{}]:reloadStatus->loadStatus()", (Object)this.module.getName(), (Object)this.getName());
                this.remoteOptional().map(this::loadStatus).ifPresent(this::setStatus);
            }
            catch (Throwable t) {
                log.debug("[{}:{}]:reloadStatus->loadStatus()=EXCEPTION", new Object[]{this.module.getName(), this.getName(), t});
                this.setStatus("Unknown");
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    public String getStatus() {
        String status = this.statusRef.get();
        if (this.syncTimeRef.get() < 0L) {
            log.debug("[{}:{}]:getStatus->reloadStatus()", (Object)this.module.getName(), (Object)this.getName());
            AzureTaskManager.getInstance().runOnPooledThread(this::reloadStatus);
            return this.statusRef.get();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String getStatusSync() {
        AtomicReference<String> atomicReference = this.statusRef;
        synchronized (atomicReference) {
            String status = this.statusRef.get();
            while (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"Loading")) {
                try {
                    this.statusRef.wait();
                    status = this.statusRef.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.syncTimeRef.get() < 0L) {
                log.debug("[{}:{}]:getStatusSync->reloadStatus()", (Object)this.module.getName(), (Object)this.getName());
                this.reloadStatus();
                return this.statusRef.get();
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doModify(@Nonnull Runnable body, @Nullable String status) {
        this.setStatus(Optional.ofNullable(status).orElse("Pending"));
        try {
            body.run();
            log.debug("[{}:{}]:doModify->refreshRemote()", (Object)this.module.getName(), (Object)this.getName());
            R refreshed = Optional.ofNullable(this.remoteRef.get()).map(this::refreshRemote).orElse(null);
            log.debug("[{}:{}]:doModify->setRemote({})", new Object[]{this.module.getName(), this.getName(), this.remoteRef.get()});
            this.setRemote(refreshed);
        }
        catch (Throwable t) {
            this.setStatus("Unknown");
            AtomicLong atomicLong = this.syncTimeRef;
            synchronized (atomicLong) {
                this.syncTimeRef.compareAndSet(0L, -1L);
                this.syncTimeRef.notifyAll();
            }
            throw t;
        }
    }

    protected void doModifyAsync(@Nonnull Runnable body, @Nullable String status) {
        this.setStatus(Optional.ofNullable(status).orElse("Pending"));
        AzureTaskManager.getInstance().runOnPooledThread(() -> this.doModify(body, status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public R doModify(@Nonnull Callable<R> body, @Nullable String status) {
        this.setStatus(Optional.ofNullable(status).orElse("Pending"));
        try {
            R remote = body.call();
            log.debug("[{}:{}]:doModify->setRemote({})", new Object[]{this.module.getName(), this.getName(), remote});
            this.setRemote(remote);
            return remote;
        }
        catch (Throwable t) {
            this.setStatus("Unknown");
            AtomicLong atomicLong = this.syncTimeRef;
            synchronized (atomicLong) {
                this.syncTimeRef.compareAndSet(0L, -1L);
                this.syncTimeRef.notifyAll();
            }
            throw new AzureToolkitRuntimeException(t);
        }
    }

    protected void doModifyAsync(@Nonnull Callable<R> body, @Nullable String status) {
        this.setStatus(Optional.ofNullable(status).orElse("Pending"));
        AzureTaskManager.getInstance().runOnPooledThread(() -> this.doModify(body, status));
    }

    private void fireStatusChangedEvent() {
        log.debug("[{}]:fireStatusChangedEvent()", (Object)this.getName());
        AzureEventBus.emit("resource.status_changed.resource", this);
    }

    @Override
    @Nonnull
    public String getId() {
        if (this.remoteRef.get() instanceof HasId) {
            return ((HasId)this.remoteRef.get()).id();
        }
        return ((AbstractAzResourceModule)this.getModule()).toResourceId(this.getName(), this.getResourceGroupName());
    }

    @Nonnull
    public abstract List<AbstractAzResourceModule<?, T, ?>> getSubModules();

    @Nonnull
    public abstract String loadStatus(@Nonnull R var1);

    @Nonnull
    protected Optional<R> remoteOptional() {
        return Optional.ofNullable(this.getRemote());
    }

    @Nonnull
    private <D> D cast(@Nonnull Object origin) {
        return (D)origin;
    }

    @Nullable
    public AbstractAzResourceModule<?, T, ?> getSubModule(String moduleName) {
        return this.getSubModules().stream().filter(m -> m.getName().equals(moduleName)).findAny().orElse(null);
    }

    @Nullable
    public ResourceGroup getResourceGroup() {
        boolean isResourceGroupSet;
        String rgName = this.getResourceGroupName();
        String sid = this.getSubscriptionId();
        boolean isSubscriptionSet = StringUtils.isNotBlank((CharSequence)sid) && !StringUtils.equalsAnyIgnoreCase((CharSequence)sid, (CharSequence[])new CharSequence[]{"<none>", NONE.getName()});
        boolean bl = isResourceGroupSet = StringUtils.isNotBlank((CharSequence)rgName) && !StringUtils.equalsAnyIgnoreCase((CharSequence)rgName, (CharSequence[])new CharSequence[]{"<none>", NONE.getName(), "${rg}"});
        if (!isResourceGroupSet || !isSubscriptionSet) {
            return null;
        }
        return (ResourceGroup)Azure.az(AzureResources.class).groups(this.getSubscriptionId()).get(rgName, rgName);
    }

    public boolean isDraft() {
        return this.isDraftForCreating() || this.isDraftForUpdating();
    }

    public boolean isDraftForCreating() {
        return this instanceof AzResource.Draft && Objects.isNull(((AzResource.Draft)((Object)this)).getOrigin()) && Objects.isNull(this.remoteRef.get());
    }

    public boolean isDraftForUpdating() {
        return this instanceof AzResource.Draft && Objects.nonNull(((AzResource.Draft)((Object)this)).getOrigin());
    }

    public String toString() {
        return "AbstractAzResource(name=" + this.getName() + ", resourceGroupName=" + this.getResourceGroupName() + ", syncTimeRef=" + this.syncTimeRef + ", statusRef=" + this.statusRef + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractAzResource)) {
            return false;
        }
        AbstractAzResource other = (AbstractAzResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$resourceGroupName = this.getResourceGroupName();
        String other$resourceGroupName = other.getResourceGroupName();
        if (this$resourceGroupName == null ? other$resourceGroupName != null : !this$resourceGroupName.equals(other$resourceGroupName)) {
            return false;
        }
        AzResourceModule this$module = this.getModule();
        AzResourceModule other$module = other.getModule();
        return !(this$module == null ? other$module != null : !this$module.equals(other$module));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractAzResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $resourceGroupName = this.getResourceGroupName();
        result = result * 59 + ($resourceGroupName == null ? 43 : $resourceGroupName.hashCode());
        AzResourceModule $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        return result;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    @Nonnull
    public AbstractAzResourceModule<T, P, R> getModule() {
        return this.module;
    }

    static {
        AbstractAzResource.ajc$preClinit();
        log = LoggerFactory.getLogger(AbstractAzResource.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzResource.java", AbstractAzResource.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reloadRemote", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource", "", "", "", "void"), 142);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reloadStatus", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource", "", "", "", "void"), 286);
    }
}

